/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.pt;

import com.hankcs.algorithm.AhoCorasickDoubleArrayTrie;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.languagetool.rules.AbstractDashRule;
import org.languagetool.rules.ITSIssueType;

public class PreReformPortugueseDashRule
extends AbstractDashRule {
    private static final Pattern PATTERN = Pattern.compile("[a-zA-Z\u00c2\u00e2\u00c3\u00e3\u00c7\u00e7\u00ca\u00ea\u00d3\u00f3\u00d4\u00f4\u00d5\u00f5\u00fc]");
    private static volatile AhoCorasickDoubleArrayTrie<String> trie;

    public PreReformPortugueseDashRule(ResourceBundle messages) {
        super(messages);
        this.setLocQualityIssueType(ITSIssueType.Typographical);
    }

    public String getId() {
        return "PT_PREAO_DASH_RULE";
    }

    public String getDescription() {
        return "Travess\u00f5es no lugar de h\u00edfens";
    }

    public String getMessage() {
        return "Um travess\u00e3o foi utilizado em vez de um h\u00edfen.";
    }

    protected boolean isBoundary(String s) {
        return !PATTERN.matcher(s).matches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected AhoCorasickDoubleArrayTrie<String> getCompoundsData() {
        AhoCorasickDoubleArrayTrie data = trie;
        if (data != null) return data;
        Class<PreReformPortugueseDashRule> clazz = PreReformPortugueseDashRule.class;
        synchronized (PreReformPortugueseDashRule.class) {
            data = trie;
            if (data != null) return data;
            trie = data = PreReformPortugueseDashRule.loadCompoundFile((String)"/pt/pre-reform-compounds.txt");
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return data;
        }
    }
}

