/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.pt;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.language.Portuguese;
import org.languagetool.rules.AbstractSimpleReplaceRule2;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.tools.Tools;

public class PortugueseWeaselWordsRule
extends AbstractSimpleReplaceRule2 {
    public static final String PT_WEASELWORD_REPLACE = "PT_WEASELWORD_REPLACE";
    private static final String FILE_NAME = "/pt/weaselwords.txt";
    private static final Locale PT_LOCALE = new Locale("pt");

    public List<String> getFileNames() {
        return Collections.singletonList(FILE_NAME);
    }

    public PortugueseWeaselWordsRule(ResourceBundle messages) {
        super(messages, (Language)Portuguese.getInstance());
        this.setCategory(Categories.STYLE.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Style);
        this.addExamplePair(Example.wrong((String)"<marker>Diz-se</marker> que programas gratuitos n\u00e3o t\u00eam qualidade."), Example.fixed((String)"<marker>XYZ</marker> dizem que programas gratuitos n\u00e3o t\u00eam qualidade. Por isso vendem programas pagos."));
    }

    public String getId() {
        return PT_WEASELWORD_REPLACE;
    }

    public String getDescription() {
        return "Escrita avan\u00e7ada: Express\u00f5es evasivas";
    }

    public String getShort() {
        return "Express\u00e3o evasiva";
    }

    public String getMessage() {
        return "'$match' \u00e9 uma express\u00e3o amb\u00edgua e evasiva. Reconsidere o seu uso, de acordo com o objetivo do seu texto.";
    }

    public String getSuggestionsSeparator() {
        return " ou ";
    }

    public URL getUrl() {
        return Tools.getUrl((String)"https://pt.wikipedia.org/wiki/Weasel_word");
    }

    public Locale getLocale() {
        return PT_LOCALE;
    }
}

