/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NotNull;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.UserConfig;
import org.languagetool.language.Portuguese;
import org.languagetool.rules.Rule;
import org.languagetool.rules.pt.PortugalPortugueseReplaceRule;
import org.languagetool.rules.pt.PortugueseAgreementReplaceRule;
import org.languagetool.rules.pt.PortugueseArchaismsRule;
import org.languagetool.rules.pt.PortugueseBarbarismsRule;
import org.languagetool.rules.pt.PortugueseClicheRule;
import org.languagetool.rules.pt.PortugueseRedundancyRule;
import org.languagetool.rules.pt.PortugueseWikipediaRule;
import org.languagetool.rules.pt.PortugueseWordinessRule;
import org.languagetool.rules.pt.PostReformPortugueseCompoundRule;
import org.languagetool.rules.pt.PostReformPortugueseDashRule;

public class PortugalPortuguese
extends Portuguese {
    private static final String LANGUAGE_SHORT_CODE = "pt-PT";
    private static volatile Throwable instantiationTrace;
    private static final Map<String, Integer> id2prio;

    public PortugalPortuguese() {
        this(false);
        Throwable trace = instantiationTrace;
        if (trace != null) {
            throw new RuntimeException("Language was already instantiated, see the cause stacktrace below.", trace);
        }
        instantiationTrace = new Throwable();
    }

    protected PortugalPortuguese(boolean fakeValue) {
        super(fakeValue);
    }

    @Override
    public String getName() {
        return "Portuguese (Portugal)";
    }

    @Override
    public String[] getCountries() {
        return new String[]{"PT"};
    }

    @Override
    public List<Rule> getRelevantRules(ResourceBundle messages, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
        ArrayList<Rule> rules = new ArrayList<Rule>(super.getRelevantRules(messages, userConfig, motherTongue, altLanguages));
        rules.add((Rule)new PostReformPortugueseCompoundRule(messages, (Language)this, userConfig));
        rules.add((Rule)new PostReformPortugueseDashRule(messages));
        rules.add((Rule)new PortugueseAgreementReplaceRule(messages, (Language)this));
        rules.add((Rule)new PortugalPortugueseReplaceRule(messages, "/pt/pt-PT/replace.txt", (Language)this));
        rules.add((Rule)new PortugueseBarbarismsRule(messages, "/pt/pt-PT/barbarisms.txt", (Language)this));
        rules.add((Rule)new PortugueseArchaismsRule(messages, "/pt/pt-PT/archaisms.txt", (Language)this));
        rules.add((Rule)new PortugueseClicheRule(messages, "/pt/pt-PT/cliches.txt", (Language)this));
        rules.add((Rule)new PortugueseRedundancyRule(messages, "/pt/pt-PT/redundancies.txt", (Language)this));
        rules.add((Rule)new PortugueseWordinessRule(messages, "/pt/pt-PT/wordiness.txt", (Language)this));
        rules.add((Rule)new PortugueseWikipediaRule(messages, "/pt/pt-PT/wikipedia.txt", (Language)this));
        return rules;
    }

    @Override
    public Map<String, Integer> getPriorityMap() {
        return id2prio;
    }

    @Override
    protected int getPriorityForId(String id) {
        Integer prio = id2prio.get(id);
        if (prio != null) {
            return prio;
        }
        return super.getPriorityForId(id);
    }

    @Override
    public String getOpeningDoubleQuote() {
        return "\u00ab";
    }

    @Override
    public String getClosingDoubleQuote() {
        return "\u00bb";
    }

    @NotNull
    public static Portuguese getInstance() {
        Language language = Objects.requireNonNull(Languages.getLanguageForShortCode((String)LANGUAGE_SHORT_CODE));
        if (language instanceof Portuguese) {
            Portuguese portugalPortuguese = (Portuguese)language;
            return portugalPortuguese;
        }
        throw new RuntimeException("PortugalPortuguese language expected, got " + language);
    }

    static {
        id2prio = new HashMap<String, Integer>();
        id2prio.put("PT_COMPOUNDS_POST_REFORM", 1);
        id2prio.put("PORTUGUESE_OLD_SPELLING_INTERNAL", -9);
    }
}

