/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.pt;

import java.io.IOException;
import java.util.Map;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.language.Portuguese;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.RuleFilter;
import org.languagetool.synthesis.pt.PortugueseSynthesizer;
import org.languagetool.tools.StringTools;

public class RegularIrregularParticipleFilter
extends RuleFilter {
    private Language language = new Portuguese();
    private PortugueseSynthesizer synth = (PortugueseSynthesizer)this.language.getSynthesizer();

    public RuleMatch acceptRuleMatch(RuleMatch match, Map<String, String> arguments, int patternTokenPos, AnalyzedTokenReadings[] patternTokens) throws IOException {
        String direction = this.getRequired("direction", arguments);
        AnalyzedTokenReadings atr = null;
        for (AnalyzedTokenReadings token : patternTokens) {
            if (token.getStartPos() != match.getFromPos()) continue;
            atr = token;
            break;
        }
        String replacement = null;
        if (atr.hasPosTagStartingWith("VMP")) {
            String[] participles;
            AnalyzedToken selectedAT = null;
            String desiredPostag = null;
            for (AnalyzedToken at : atr) {
                if (at.getPOSTag() == null || !at.getPOSTag().startsWith("VMP")) continue;
                selectedAT = at;
                desiredPostag = at.getPOSTag();
            }
            desiredPostag = desiredPostag.endsWith("C") ? desiredPostag.substring(0, desiredPostag.length() - 1) + "[MC]" : desiredPostag.substring(0, desiredPostag.length() - 1) + "[" + desiredPostag.substring(desiredPostag.length() - 1) + "C]";
            try {
                participles = this.synth.synthesize(selectedAT, desiredPostag, true);
            }
            catch (IOException e) {
                throw new IOException("Cannot synthesize " + selectedAT.toString() + e);
            }
            if (participles != null && participles.length > 1) {
                if (direction.equalsIgnoreCase("RegularToIrregular") && this.isRegular(atr.getToken())) {
                    if (!this.isRegular(participles[0])) {
                        replacement = participles[0];
                    } else if (!this.isRegular(participles[1])) {
                        replacement = participles[1];
                    }
                } else if (direction.equalsIgnoreCase("IrregularToRegular") && !this.isRegular(atr.getToken())) {
                    if (this.isRegular(participles[0])) {
                        replacement = participles[0];
                    } else if (this.isRegular(participles[1])) {
                        replacement = participles[1];
                    }
                }
                if (replacement != null) {
                    String message = match.getMessage();
                    RuleMatch ruleMatch = new RuleMatch(match.getRule(), match.getSentence(), match.getFromPos(), match.getToPos(), message, match.getShortMessage());
                    ruleMatch.setType(match.getType());
                    String suggestion = ((String)match.getSuggestedReplacements().get(0)).replace("{suggestion}", replacement);
                    suggestion = suggestion.replace("{Suggestion}", StringTools.uppercaseFirstChar((String)replacement));
                    suggestion = suggestion.replace("{SUGGESTION}", replacement.toUpperCase());
                    ruleMatch.setSuggestedReplacement(suggestion);
                    return ruleMatch;
                }
            }
        }
        return null;
    }

    boolean isRegular(String p) {
        String lp = p.toLowerCase();
        return lp.endsWith("do") || lp.endsWith("dos") || lp.endsWith("da") || lp.endsWith("das");
    }
}

