/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.pt;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.rules.AbstractSimpleReplaceRule2;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.tools.Tools;

public class PortugueseRedundancyRule
extends AbstractSimpleReplaceRule2 {
    public static final String PT_REDUNDANCY_REPLACE = "PT_REDUNDANCY_REPLACE";
    private static final Locale PT_LOCALE = new Locale("pt");
    private final String path;

    public List<String> getFileNames() {
        return Collections.singletonList(this.path);
    }

    public PortugueseRedundancyRule(ResourceBundle messages, String path, Language language) {
        super(messages, language);
        this.path = Objects.requireNonNull(path);
        this.setCategory(Categories.REDUNDANCY.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Style);
        this.useSubRuleSpecificIds();
        this.addExamplePair(Example.wrong((String)"<marker>duna de areia</marker>"), Example.fixed((String)"<marker>duna</marker>"));
    }

    public String getId() {
        return PT_REDUNDANCY_REPLACE;
    }

    public String getDescription() {
        return "1. Pleonasmos e redund\u00e2ncias: $match";
    }

    public String getShort() {
        return "Pleonasmo";
    }

    public String getMessage() {
        return "\"$match\" \u00e9 um pleonasmo. \u00c9 prefer\u00edvel dizer $suggestions";
    }

    public String getSuggestionsSeparator() {
        return " ou ";
    }

    public URL getUrl() {
        return Tools.getUrl((String)"https://pt.wikipedia.org/wiki/Pleonasmo");
    }

    public Locale getLocale() {
        return PT_LOCALE;
    }
}

