/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.jetbrains.annotations.Nullable;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.language.Portuguese;
import org.languagetool.rules.Rule;
import org.languagetool.rules.pt.PortugalPortugueseReplaceRule;
import org.languagetool.rules.pt.PortugueseAgreementReplaceRule;
import org.languagetool.rules.pt.PortugueseArchaismsRule;
import org.languagetool.rules.pt.PortugueseBarbarismsRule;
import org.languagetool.rules.pt.PortugueseClicheRule;
import org.languagetool.rules.pt.PortugueseRedundancyRule;
import org.languagetool.rules.pt.PortugueseWikipediaRule;
import org.languagetool.rules.pt.PortugueseWordinessRule;
import org.languagetool.rules.pt.PostReformPortugueseCompoundRule;
import org.languagetool.rules.pt.PostReformPortugueseDashRule;
import org.languagetool.rules.spelling.SpellingCheckRule;
import org.languagetool.rules.spelling.hunspell.HunspellRule;

public class PortugalPortuguese
extends Portuguese {
    @Override
    public String getName() {
        return "Portuguese (Portugal)";
    }

    @Override
    public String[] getCountries() {
        return new String[]{"PT"};
    }

    @Override
    public List<Rule> getRelevantRules(ResourceBundle messages, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
        ArrayList<Rule> rules = new ArrayList<Rule>(super.getRelevantRules(messages, userConfig, motherTongue, altLanguages));
        rules.add((Rule)new PostReformPortugueseCompoundRule(messages, this, userConfig));
        rules.add((Rule)new PostReformPortugueseDashRule(messages));
        rules.add((Rule)new PortugueseAgreementReplaceRule(messages, this));
        rules.add((Rule)new PortugalPortugueseReplaceRule(messages, "/pt/pt-PT/replace.txt", this));
        rules.add((Rule)new PortugueseBarbarismsRule(messages, "/pt/pt-PT/barbarisms.txt", this));
        rules.add((Rule)new PortugueseArchaismsRule(messages, "/pt/pt-PT/archaisms.txt", this));
        rules.add((Rule)new PortugueseClicheRule(messages, "/pt/pt-PT/cliches.txt", this));
        rules.add((Rule)new PortugueseRedundancyRule(messages, "/pt/pt-PT/redundancies.txt", this));
        rules.add((Rule)new PortugueseWordinessRule(messages, "/pt/pt-PT/wordiness.txt", this));
        rules.add((Rule)new PortugueseWikipediaRule(messages, "/pt/pt-PT/wikipedia.txt", this));
        return rules;
    }

    @Override
    protected int getPriorityForId(String id) {
        switch (id) {
            case "PT_COMPOUNDS_POST_REFORM": {
                return 1;
            }
            case "PORTUGUESE_OLD_SPELLING_INTERNAL": {
                return -9;
            }
        }
        return super.getPriorityForId(id);
    }

    @Nullable
    protected SpellingCheckRule createDefaultSpellingRule(ResourceBundle messages) throws IOException {
        return new HunspellRule(messages, (Language)this, null, null);
    }

    @Override
    public String getOpeningDoubleQuote() {
        return "\u00ab";
    }

    @Override
    public String getClosingDoubleQuote() {
        return "\u00bb";
    }
}

