/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.language.Portuguese;
import org.languagetool.rules.Rule;
import org.languagetool.rules.pt.PortugalPortugueseReplaceRule;
import org.languagetool.rules.pt.PortugueseAgreementReplaceRule;
import org.languagetool.rules.pt.PortugueseArchaismsRule;
import org.languagetool.rules.pt.PortugueseBarbarismsRule;
import org.languagetool.rules.pt.PostReformPortugueseCompoundRule;
import org.languagetool.rules.pt.PostReformPortugueseDashRule;

public class PortugalPortuguese
extends Portuguese {
    @Override
    public String getName() {
        return "Portuguese (Portugal)";
    }

    @Override
    public String[] getCountries() {
        return new String[]{"PT"};
    }

    @Override
    public List<Rule> getRelevantRules(ResourceBundle messages, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        rules.addAll(super.getRelevantRules(messages, userConfig, motherTongue, altLanguages));
        rules.add((Rule)new PostReformPortugueseCompoundRule(messages, this, userConfig));
        rules.add((Rule)new PostReformPortugueseDashRule(messages));
        rules.add((Rule)new PortugalPortugueseReplaceRule(messages, "/pt/pt-PT/replace.txt"));
        rules.add((Rule)new PortugueseAgreementReplaceRule(messages));
        rules.add((Rule)new PortugueseBarbarismsRule(messages, "/pt/barbarisms-pt-PT.txt"));
        rules.add((Rule)new PortugueseArchaismsRule(messages, "/pt/archaisms-pt-PT.txt"));
        return rules;
    }

    @Override
    protected int getPriorityForId(String id) {
        switch (id) {
            case "PT_COMPOUNDS_POST_REFORM": {
                return 1;
            }
            case "PORTUGUESE_OLD_SPELLING_INTERNAL": {
                return -9;
            }
        }
        return super.getPriorityForId(id);
    }
}

