/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.pt;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.language.Portuguese;
import org.languagetool.rules.AbstractSimpleReplaceRule2;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.tools.Tools;

public class PortugueseBarbarismsRule
extends AbstractSimpleReplaceRule2 {
    public static final String PT_BARBARISMS_REPLACE = "PT_BARBARISMS_REPLACE";
    private static final Locale PT_LOCALE = new Locale("pt");
    private final String path;

    public List<String> getFileNames() {
        return Collections.singletonList(this.path);
    }

    public PortugueseBarbarismsRule(ResourceBundle messages, String path) {
        super(messages, (Language)new Portuguese());
        this.path = Objects.requireNonNull(path);
        super.setCategory(Categories.STYLE.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.LocaleViolation);
        this.addExamplePair(Example.wrong((String)"<marker>curriculum vitae</marker>"), Example.fixed((String)"<marker>curr\u00edculo</marker>"));
    }

    public String getId() {
        return PT_BARBARISMS_REPLACE;
    }

    public String getDescription() {
        return "Palavras de origem estrangeira evit\u00e1veis";
    }

    public String getShort() {
        return "Estrangeirismo";
    }

    public String getSuggestion() {
        return "'$match' \u00e9 um estrangeirismo. \u00c9 prefer\u00edvel dizer $suggestions";
    }

    public String getSuggestionsSeparator() {
        return " ou ";
    }

    public URL getUrl() {
        return Tools.getUrl((String)"https://pt.wikipedia.org/wiki/Estrangeirismo");
    }

    public Locale getLocale() {
        return PT_LOCALE;
    }
}

