/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.pt;

import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.language.Portuguese;
import org.languagetool.rules.AbstractSimpleReplaceRule2;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.tools.Tools;

public class PortugueseDiacriticsRule
extends AbstractSimpleReplaceRule2 {
    public static final String PT_DIACRITICS_REPLACE = "PT_DIACRITICS_REPLACE";
    private static final String FILE_NAME = "/pt/diacritics.txt";
    private static final Locale PT_LOCALE = new Locale("pt");

    public final String getFileName() {
        return FILE_NAME;
    }

    public PortugueseDiacriticsRule(ResourceBundle messages) throws IOException {
        super(messages, (Language)new Portuguese());
        this.setDefaultOff();
        super.setCategory(Categories.TYPOS.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Misspelling);
        this.addExamplePair(Example.wrong((String)"<marker>coupe</marker>"), Example.fixed((String)"<marker>coup\u00e9</marker>"));
    }

    public final String getId() {
        return PT_DIACRITICS_REPLACE;
    }

    public String getDescription() {
        return "Palavras estrangeiras com diacr\u00edticos";
    }

    public String getShort() {
        return "A palavra estrangeira original tem diacr\u00edtico";
    }

    public String getSuggestion() {
        return "'$match' \u00e9 uma express\u00e3o estrangeira importada cuja grafia tem diacr\u00edticos. \u00c9 prefer\u00edvel escrever $suggestions";
    }

    public String getSuggestionsSeparator() {
        return " ou ";
    }

    public URL getUrl() {
        return Tools.getUrl((String)"http://escreverbem.com.br/o-frances-no-portugues-2/");
    }

    public Locale getLocale() {
        return PT_LOCALE;
    }
}

