/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.LanguageMaintainedState;
import org.languagetool.language.Contributor;
import org.languagetool.language.PortugalPortuguese;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.languagemodel.LuceneLanguageModel;
import org.languagetool.rules.CommaWhitespaceRule;
import org.languagetool.rules.Example;
import org.languagetool.rules.GenericUnpairedBracketsRule;
import org.languagetool.rules.LongSentenceRule;
import org.languagetool.rules.MultipleWhitespaceRule;
import org.languagetool.rules.Rule;
import org.languagetool.rules.SentenceWhitespaceRule;
import org.languagetool.rules.UppercaseSentenceStartRule;
import org.languagetool.rules.pt.PortugueseAccentuationCheckRule;
import org.languagetool.rules.pt.PortugueseClicheRule;
import org.languagetool.rules.pt.PortugueseConfusionProbabilityRule;
import org.languagetool.rules.pt.PortugueseRedundancyRule;
import org.languagetool.rules.pt.PortugueseReplaceRule;
import org.languagetool.rules.pt.PortugueseReplaceRule2;
import org.languagetool.rules.pt.PortugueseWeaselWordsRule;
import org.languagetool.rules.pt.PortugueseWikipediaRule;
import org.languagetool.rules.pt.PortugueseWordCoherencyRule;
import org.languagetool.rules.pt.PortugueseWordRepeatBeginningRule;
import org.languagetool.rules.pt.PortugueseWordRepeatRule;
import org.languagetool.rules.pt.PortugueseWordinessRule;
import org.languagetool.rules.pt.PortugueseWrongWordInContextRule;
import org.languagetool.rules.pt.PostReformPortugueseCompoundRule;
import org.languagetool.rules.spelling.hunspell.HunspellRule;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.synthesis.pt.PortugueseSynthesizer;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tagging.disambiguation.pt.PortugueseHybridDisambiguator;
import org.languagetool.tagging.pt.PortugueseTagger;
import org.languagetool.tokenizers.SRXSentenceTokenizer;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tokenizers.Tokenizer;
import org.languagetool.tokenizers.pt.PortugueseWordTokenizer;

public class Portuguese
extends Language
implements AutoCloseable {
    private static final Language PORTUGAL_PORTUGUESE = new PortugalPortuguese();
    private Tagger tagger;
    private Disambiguator disambiguator;
    private Tokenizer wordTokenizer;
    private Synthesizer synthesizer;
    private SentenceTokenizer sentenceTokenizer;
    private LuceneLanguageModel languageModel;

    public String getName() {
        return "Portuguese";
    }

    public String getShortCode() {
        return "pt";
    }

    public String[] getCountries() {
        return new String[]{"", "CV", "GW", "MO", "ST", "TL"};
    }

    public Language getDefaultLanguageVariant() {
        return PORTUGAL_PORTUGUESE;
    }

    public Contributor[] getMaintainers() {
        return new Contributor[]{new Contributor("Marco A.G. Pinto", "http://www.marcoagpinto.com/"), new Contributor("Matheus Poletto", "https://github.com/MatheusPoletto"), new Contributor("Tiago F. Santos (3.6+)", "https://github.com/TiagoSantos81")};
    }

    public Tagger getTagger() {
        if (this.tagger == null) {
            this.tagger = new PortugueseTagger();
        }
        return this.tagger;
    }

    public Disambiguator getDisambiguator() {
        if (this.disambiguator == null) {
            this.disambiguator = new PortugueseHybridDisambiguator();
        }
        return this.disambiguator;
    }

    public Tokenizer getWordTokenizer() {
        if (this.wordTokenizer == null) {
            this.wordTokenizer = new PortugueseWordTokenizer();
        }
        return this.wordTokenizer;
    }

    public Synthesizer getSynthesizer() {
        if (this.synthesizer == null) {
            this.synthesizer = new PortugueseSynthesizer();
        }
        return this.synthesizer;
    }

    public SentenceTokenizer getSentenceTokenizer() {
        if (this.sentenceTokenizer == null) {
            this.sentenceTokenizer = new SRXSentenceTokenizer((Language)this);
        }
        return this.sentenceTokenizer;
    }

    public List<Rule> getRelevantRules(ResourceBundle messages) throws IOException {
        return Arrays.asList(new Rule[]{new CommaWhitespaceRule(messages, Example.wrong((String)"Tomamos caf\u00e9<marker> ,</marker> queijo, bolachas e uvas."), Example.fixed((String)"Tomamos caf\u00e9<marker>,</marker> queijo, bolachas e uvas")), new GenericUnpairedBracketsRule(messages, Arrays.asList("[", "(", "{", "\"", "\u201c"), Arrays.asList("]", ")", "}", "\"", "\u201d")), new HunspellRule(messages, (Language)this), new LongSentenceRule(messages, 45, true), new UppercaseSentenceStartRule(messages, (Language)this, Example.wrong((String)"Esta casa \u00e9 velha. <marker>foi</marker> construida em 1950."), Example.fixed((String)"Esta casa \u00e9 velha. <marker>Foi</marker> construida em 1950.")), new MultipleWhitespaceRule(messages, (Language)this), new SentenceWhitespaceRule(messages), new PostReformPortugueseCompoundRule(messages), new PortugueseReplaceRule(messages), new PortugueseReplaceRule2(messages), new PortugueseClicheRule(messages), new PortugueseRedundancyRule(messages), new PortugueseWordinessRule(messages), new PortugueseWeaselWordsRule(messages), new PortugueseWikipediaRule(messages), new PortugueseWordRepeatRule(messages, this), new PortugueseWordRepeatBeginningRule(messages, this), new PortugueseAccentuationCheckRule(messages), new PortugueseWrongWordInContextRule(messages), new PortugueseWordCoherencyRule(messages)});
    }

    public LanguageMaintainedState getMaintainedState() {
        return LanguageMaintainedState.ActivelyMaintained;
    }

    public synchronized LanguageModel getLanguageModel(File indexDir) throws IOException {
        if (this.languageModel == null) {
            this.languageModel = new LuceneLanguageModel(new File(indexDir, this.getShortCode()));
        }
        return this.languageModel;
    }

    public List<Rule> getRelevantLanguageModelRules(ResourceBundle messages, LanguageModel languageModel) throws IOException {
        return Arrays.asList(new Rule[]{new PortugueseConfusionProbabilityRule(messages, languageModel, this)});
    }

    @Override
    public void close() throws Exception {
        if (this.languageModel != null) {
            this.languageModel.close();
        }
    }

    public int getPriorityForId(String id) {
        switch (id) {
            case "FRAGMENT_TWO_ARTICLES": {
                return 50;
            }
            case "DEGREE_MINUTES_SECONDS": {
                return 20;
            }
            case "INTERJECTIONS_PUNTUATION": {
                return 10;
            }
            case "CONFUSION_POR": {
                return 5;
            }
            case "HOMOPHONE_AS_CARD": {
                return 3;
            }
            case "TODOS_PLURAL_NOUNS": {
                return -4;
            }
            case "UNPAIRED_BRACKETS": {
                return -5;
            }
            case "PROFANITY": {
                return -6;
            }
            case "PT_MULTI_REPLACE": {
                return -10;
            }
            case "PT_PT_SIMPLE_REPLACE": {
                return -11;
            }
            case "PT_REDUNDANCY_REPLACE": {
                return -12;
            }
            case "PT_WORDINESS_REPLACE": {
                return -13;
            }
            case "PT_CLICHE_REPLACE": {
                return -17;
            }
            case "CHILDISH_LANGUAGE": {
                return -25;
            }
            case "ARCHAISMS": {
                return -26;
            }
            case "INFORMALITIES": {
                return -27;
            }
            case "PUFFERY": {
                return -30;
            }
            case "BIASED_OPINION_WORDS": {
                return -31;
            }
            case "WEAK_WORDS": {
                return -32;
            }
            case "PT_AGREEMENT_REPLACE": {
                return -35;
            }
            case "HUNSPELL_RULE": {
                return -50;
            }
            case "NO_VERB": {
                return -52;
            }
            case "CRASE_CONFUSION": {
                return -55;
            }
            case "FINAL_STOPS": {
                return -75;
            }
            case "T-V_DISTINCTION": {
                return -100;
            }
            case "T-V_DISTINCTION_ALL": {
                return -101;
            }
            case "REPEATED_WORDS": {
                return -210;
            }
            case "REPEATED_WORDS_3X": {
                return -211;
            }
            case "WIKIPEDIA_COMMON_ERRORS": {
                return -500;
            }
            case "TOO_LONG_SENTENCE": {
                return -1000;
            }
            case "CACOPHONY": {
                return -2000;
            }
        }
        return 0;
    }
}

