/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.pt;

import java.util.ResourceBundle;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.WrongWordInContextRule;

public class PortugueseWrongWordInContextRule
extends WrongWordInContextRule {
    public PortugueseWrongWordInContextRule(ResourceBundle messages) {
        super(messages);
        super.setCategory(Categories.SEMANTICS.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Grammar);
        this.addExamplePair(Example.wrong((String)"O acidente <marker>infringiu</marker> grandes danos."), Example.fixed((String)"O acidente <marker>infligiu</marker> grandes danos."));
    }

    protected String getCategoryString() {
        return "Confus\u00e3o de Palavras";
    }

    public String getId() {
        return "PORTUGUESE_WRONG_WORD_IN_CONTEXT";
    }

    public String getDescription() {
        return "Confus\u00e3o de palavra dentro do contexto (Infligir/Infringir, etc.)";
    }

    protected String getFilename() {
        return "/pt/wrongWordInContext.txt";
    }

    protected String getMessageString() {
        return "Pretende dizer <suggestion>$SUGGESTION</suggestion> em vez de $WRONGWORD?";
    }

    protected String getShortMessageString() {
        return "Poss\u00edvel confus\u00e3o";
    }

    protected String getLongMessageString() {
        return "Pretende dizer <suggestion>$SUGGESTION</suggestion> (= $EXPLANATION_SUGGESTION) em vez de '$WRONGWORD' (= $EXPLANATION_WRONGWORD)?";
    }
}

