/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.language.Contributor;
import org.languagetool.language.PortugalPortuguese;
import org.languagetool.rules.CommaWhitespaceRule;
import org.languagetool.rules.DoublePunctuationRule;
import org.languagetool.rules.GenericUnpairedBracketsRule;
import org.languagetool.rules.MultipleWhitespaceRule;
import org.languagetool.rules.Rule;
import org.languagetool.rules.SentenceWhitespaceRule;
import org.languagetool.rules.UppercaseSentenceStartRule;
import org.languagetool.rules.WordRepeatRule;
import org.languagetool.rules.pt.PreReformPortugueseCompoundRule;
import org.languagetool.rules.spelling.hunspell.HunspellNoSuggestionRule;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.pt.PortugueseTagger;
import org.languagetool.tokenizers.SRXSentenceTokenizer;
import org.languagetool.tokenizers.SentenceTokenizer;

public class Portuguese
extends Language {
    private Tagger tagger;
    private SentenceTokenizer sentenceTokenizer;
    private String name = "Portuguese";

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getShortName() {
        return "pt";
    }

    public String[] getCountries() {
        return new String[]{"AO", "MZ"};
    }

    public Language getDefaultLanguageVariant() {
        return new PortugalPortuguese();
    }

    public Contributor[] getMaintainers() {
        Contributor contributor = new Contributor("Marco A.G. Pinto");
        contributor.setUrl("http://www.marcoagpinto.com/");
        return new Contributor[]{contributor};
    }

    public Tagger getTagger() {
        if (this.tagger == null) {
            this.tagger = new PortugueseTagger();
        }
        return this.tagger;
    }

    public SentenceTokenizer getSentenceTokenizer() {
        if (this.sentenceTokenizer == null) {
            this.sentenceTokenizer = new SRXSentenceTokenizer((Language)this);
        }
        return this.sentenceTokenizer;
    }

    public List<Rule> getRelevantRules(ResourceBundle messages) throws IOException {
        return Arrays.asList(new Rule[]{new CommaWhitespaceRule(messages), new DoublePunctuationRule(messages), new GenericUnpairedBracketsRule(messages, (Language)this), new HunspellNoSuggestionRule(messages, (Language)this), new UppercaseSentenceStartRule(messages, (Language)this), new WordRepeatRule(messages, (Language)this), new MultipleWhitespaceRule(messages, (Language)this), new SentenceWhitespaceRule(messages), new PreReformPortugueseCompoundRule(messages)});
    }
}

