/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.synthesis.pl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import morfologik.stemming.DictionaryLookup;
import morfologik.stemming.IStemmer;
import morfologik.stemming.WordData;
import org.languagetool.AnalyzedToken;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.synthesis.BaseSynthesizer;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.synthesis.SynthesizerTools;

public class PolishSynthesizer
extends BaseSynthesizer
implements Synthesizer {
    private static final String RESOURCE_FILENAME = "/pl/polish_synth.dict";
    private static final String TAGS_FILE_NAME = "/pl/polish_tags.txt";
    private static final String POTENTIAL_NEGATION_TAG = ":aff";
    private static final String NEGATION_TAG = ":neg";
    private static final Pattern NEGATION_TAG_PATTERN = Pattern.compile(":neg");
    private static final String COMP_TAG = "com";
    private static final String SUP_TAG = "sup";
    private static final Pattern PATTERN = Pattern.compile(".*[a-z]\\.[a-z].*");
    private static final Pattern DOT = Pattern.compile(".", 16);
    private List<String> possibleTags;
    public static final PolishSynthesizer INSTANCE = new PolishSynthesizer();

    public PolishSynthesizer(Language lang) {
        this();
    }

    private PolishSynthesizer() {
        super(RESOURCE_FILENAME, TAGS_FILE_NAME, "pl");
    }

    public final String[] synthesize(AnalyzedToken token, String posTag) throws IOException {
        if (posTag == null) {
            return null;
        }
        DictionaryLookup synthesizer = new DictionaryLookup(this.getDictionary());
        boolean isNegated = false;
        if (token.getPOSTag() != null) {
            boolean bl = isNegated = posTag.indexOf(NEGATION_TAG) > 0 || token.getPOSTag().indexOf(NEGATION_TAG) > 0 && posTag.indexOf(COMP_TAG) <= 0 && posTag.indexOf(SUP_TAG) <= 0;
        }
        if (posTag.indexOf(43) > 0) {
            return this.synthesize(token, posTag, true);
        }
        List<String> forms = this.getWordForms(token, posTag, isNegated, (IStemmer)synthesizer);
        return forms.toArray(new String[0]);
    }

    public final String[] synthesize(AnalyzedToken token, String pos, boolean posTagRegExp) throws IOException {
        if (pos == null) {
            return null;
        }
        String posTag = pos;
        if (posTagRegExp) {
            if (this.possibleTags == null) {
                try (InputStream stream = JLanguageTool.getDataBroker().getFromResourceDirAsStream(TAGS_FILE_NAME);){
                    this.possibleTags = SynthesizerTools.loadWords((InputStream)stream);
                }
            }
            DictionaryLookup synthesizer = new DictionaryLookup(this.getDictionary());
            ArrayList<String> results = new ArrayList<String>();
            boolean isNegated = false;
            if (token.getPOSTag() != null) {
                boolean bl = isNegated = posTag.indexOf(NEGATION_TAG) > 0 || token.getPOSTag().indexOf(NEGATION_TAG) > 0 && posTag.indexOf(COMP_TAG) <= 0 && posTag.indexOf(SUP_TAG) <= 0;
            }
            if (isNegated) {
                posTag = posTag.replace(NEGATION_TAG, ":aff?");
            }
            try {
                Pattern p = Pattern.compile(posTag.replace('+', '|'));
                for (String tag : this.possibleTags) {
                    List<String> wordForms;
                    Matcher m = p.matcher(tag);
                    if (!m.matches() || (wordForms = this.getWordForms(token, tag, isNegated, (IStemmer)synthesizer)) == null) continue;
                    results.addAll(wordForms);
                }
            }
            catch (PatternSyntaxException e) {
                e.printStackTrace();
            }
            HashSet hs = new HashSet(results);
            results.clear();
            results.addAll(hs);
            return results.toArray(new String[0]);
        }
        return this.synthesize(token, posTag);
    }

    public final String getPosTagCorrection(String posTag) {
        if (posTag.contains(".")) {
            String[] tags = posTag.split(":");
            int pos = -1;
            for (int i = 0; i < tags.length; ++i) {
                if (!PATTERN.matcher(tags[i]).matches()) continue;
                tags[i] = "(.*" + DOT.matcher(tags[i]).replaceAll(".*|.*") + ".*)";
                pos = i;
            }
            if (pos == -1) {
                return posTag;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(tags[0]);
            for (int i = 1; i < tags.length; ++i) {
                sb.append(':');
                sb.append(tags[i]);
            }
            return sb.toString();
        }
        return posTag;
    }

    private List<String> getWordForms(AnalyzedToken token, String posTag, boolean isNegated, IStemmer synthesizer) {
        ArrayList<String> forms;
        block3: {
            block2: {
                forms = new ArrayList<String>();
                if (!isNegated) break block2;
                List wordForms = synthesizer.lookup((CharSequence)(token.getLemma() + "|" + NEGATION_TAG_PATTERN.matcher(posTag).replaceFirst(POTENTIAL_NEGATION_TAG)));
                if (wordForms == null) break block3;
                for (WordData wd : wordForms) {
                    forms.add("nie" + wd.getStem());
                }
                break block3;
            }
            List wordForms = synthesizer.lookup((CharSequence)(token.getLemma() + "|" + posTag));
            for (WordData wd : wordForms) {
                if (wd.getStem() == null) continue;
                forms.add(wd.getStem().toString());
            }
        }
        return forms;
    }
}

