/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.pl;

import java.io.IOException;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.languagetool.rules.AbstractWordCoherencyRule;
import org.languagetool.rules.Example;
import org.languagetool.rules.WordCoherencyDataLoader;

public class WordCoherencyRule
extends AbstractWordCoherencyRule {
    private static final Map<String, Set<String>> wordMap = new WordCoherencyDataLoader().loadWords("/pl/coherency.txt");

    public WordCoherencyRule(ResourceBundle messages) throws IOException {
        super(messages);
        this.addExamplePair(Example.wrong((String)"Grapefruity s\u0105 zdrowe. <marker>Grejpfrut</marker> smakuje najlepiej sma\u017cony."), Example.fixed((String)"Grapefruity s\u0105 zdrowe. <marker>Grapefruit</marker> smakuje najlepiej sma\u017cony."));
    }

    protected Map<String, Set<String>> getWordMap() {
        return wordMap;
    }

    protected String getMessage(String word1, String word2) {
        return "'" + word1 + "' i '" + word2 + "' nie powinny by\u0107 u\u017cywane jednocze\u015bnie.";
    }

    public String getId() {
        return "PL_WORD_COHERENCY";
    }

    public String getDescription() {
        return "Jednolita pisownia wyraz\u00f3w o obocznej dopuszczalnej pisowni";
    }
}

