/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.pl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.languagetool.AnalyzedSentence;
import org.languagetool.JLanguageTool;
import org.languagetool.Languages;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.PatternRule;
import org.languagetool.rules.patterns.PatternToken;

public class DashRule
extends Rule {
    private final List<PatternRule> dashRules = new ArrayList<PatternRule>();

    public DashRule() throws IOException {
        this.loadCompoundFile("/pl/compounds.txt");
    }

    public String getId() {
        return "DASH_RULE";
    }

    public String getDescription() {
        return "Sprawdza, czy wyrazy pisane z \u0142\u0105cznikiem zapisano z my\u015blnikami (np. \u201eL\u0105dek \u2014 Zdr\u00f3j\u201d zamiast \u201eL\u0105dek-Zdr\u00f3j\u201d).";
    }

    public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        ArrayList<RuleMatch> matches = new ArrayList<RuleMatch>();
        for (PatternRule dashRule : this.dashRules) {
            for (RuleMatch ruleMatch : dashRule.match(sentence)) {
                RuleMatch rm = new RuleMatch((Rule)this, ruleMatch.getFromPos(), ruleMatch.getToPos(), ruleMatch.getMessage(), ruleMatch.getShortMessage(), false, "");
                matches.add(rm);
            }
        }
        return matches.toArray(new RuleMatch[matches.size()]);
    }

    public void reset() {
    }

    private void loadCompoundFile(String path) throws IOException {
        try (InputStream stream = JLanguageTool.getDataBroker().getFromResourceDirAsStream(path);
             InputStreamReader reader = new InputStreamReader(stream, "utf-8");
             BufferedReader br = new BufferedReader(reader);){
            String line;
            int counter = 0;
            while ((line = br.readLine()) != null) {
                ++counter;
                if (line.isEmpty() || line.charAt(0) == '#' || line.endsWith("+")) continue;
                if (line.endsWith("*")) {
                    line = this.removeLastCharacter(line);
                }
                ArrayList<PatternToken> tokList = new ArrayList<PatternToken>();
                String[] tokens = line.split("-");
                int tokenCounter = 0;
                for (String token : tokens) {
                    tokList.add(new PatternToken(token, true, false, false));
                    if (++tokenCounter >= tokens.length) continue;
                    tokList.add(new PatternToken("[\u2014\u2013]", false, true, false));
                }
                PatternRule dashRule = new PatternRule("DASH_RULE" + counter, Languages.getLanguageForName((String)"Polish"), tokList, "", "B\u0142\u0119dne u\u017cycie my\u015blnika zamiast my\u015blnika. Poprawnie: <suggestion>" + line.replaceAll("[\u2013\u2014]", "-") + "</suggestion>.", line.replaceAll("[\u2013\u2014]", "-"));
                this.dashRules.add(dashRule);
            }
        }
    }

    private String removeLastCharacter(String str) {
        return str.substring(0, str.length() - 1);
    }
}

