/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tokenizers.pl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.tagging.Tagger;
import org.languagetool.tokenizers.WordTokenizer;

public class PolishWordTokenizer
extends WordTokenizer {
    private final String plTokenizing = super.getTokenizingCharacters() + "\u2013\u2014";
    private Tagger tagger;
    private static final Set<String> prefixes;

    public List<String> tokenize(String text) {
        ArrayList<String> l = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(text, this.plTokenizing, true);
        while (st.hasMoreElements()) {
            String token = st.nextToken();
            if (token.length() > 1) {
                if (token.endsWith("-")) {
                    l.add(token.substring(0, token.length() - 1));
                    l.add("-");
                    continue;
                }
                if (token.charAt(0) == '-') {
                    l.add("-");
                    l.add(token.substring(1, token.length()));
                    continue;
                }
                if (token.contains("-")) {
                    String[] tokenParts = token.split("-");
                    if (prefixes.contains(tokenParts[0]) || this.tagger == null) {
                        l.add(token);
                        continue;
                    }
                    ArrayList<String> testedTokens = new ArrayList<String>(tokenParts.length + 1);
                    for (int i = 0; i < tokenParts.length; ++i) {
                        testedTokens.add(tokenParts[i]);
                    }
                    testedTokens.add(token);
                    try {
                        List taggedToks = this.tagger.tag(testedTokens);
                        if (taggedToks.size() == tokenParts.length + 1 && !((AnalyzedTokenReadings)taggedToks.get(tokenParts.length)).isTagged()) {
                            boolean isCompound = false;
                            switch (tokenParts.length) {
                                case 2: {
                                    if (!(((AnalyzedTokenReadings)taggedToks.get(0)).hasPosTag("adja") && ((AnalyzedTokenReadings)taggedToks.get(1)).hasPartialPosTag("adj:") || ((AnalyzedTokenReadings)taggedToks.get(0)).hasPartialPosTag("subst:") && ((AnalyzedTokenReadings)taggedToks.get(1)).hasPartialPosTag("subst:")) && (!((AnalyzedTokenReadings)taggedToks.get(0)).hasPartialPosTag("num:") || !((AnalyzedTokenReadings)taggedToks.get(1)).hasPartialPosTag("num:"))) break;
                                    isCompound = true;
                                    break;
                                }
                                case 3: {
                                    if (!((AnalyzedTokenReadings)taggedToks.get(0)).hasPosTag("adja") || !((AnalyzedTokenReadings)taggedToks.get(1)).hasPosTag("adja") || !((AnalyzedTokenReadings)taggedToks.get(2)).hasPartialPosTag("adj:")) break;
                                    isCompound = true;
                                }
                            }
                            if (isCompound) {
                                for (int i = 0; i < tokenParts.length; ++i) {
                                    l.add(tokenParts[i]);
                                    if (i == tokenParts.length - 1) continue;
                                    l.add("-");
                                }
                                continue;
                            }
                            l.add(token);
                            continue;
                        }
                        l.add(token);
                        continue;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                l.add(token);
                continue;
            }
            l.add(token);
        }
        return this.joinUrls(l);
    }

    public void setTagger(Tagger tagger) {
        this.tagger = tagger;
    }

    static {
        HashSet<String> tempSet = new HashSet<String>();
        tempSet.add("arcy");
        tempSet.add("neo");
        tempSet.add("pre");
        tempSet.add("anty");
        tempSet.add("eks");
        tempSet.add("bez");
        tempSet.add("beze");
        tempSet.add("ekstra");
        tempSet.add("hiper");
        tempSet.add("infra");
        tempSet.add("kontr");
        tempSet.add("maksi");
        tempSet.add("midi");
        tempSet.add("mi\u0119dzy");
        tempSet.add("mini");
        tempSet.add("nad");
        tempSet.add("nade");
        tempSet.add("oko\u0142o");
        tempSet.add("ponad");
        tempSet.add("post");
        tempSet.add("pro");
        tempSet.add("przeciw");
        tempSet.add("pseudo");
        tempSet.add("super");
        tempSet.add("\u015br\u00f3d");
        tempSet.add("ultra");
        tempSet.add("wice");
        tempSet.add("wok\u00f3\u0142");
        tempSet.add("woko\u0142o");
        prefixes = Collections.unmodifiableSet(tempSet);
    }
}

