/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.util.Arrays;
import java.util.List;
import org.languagetool.Language;
import org.languagetool.language.Contributor;
import org.languagetool.language.Contributors;
import org.languagetool.rules.CommaWhitespaceRule;
import org.languagetool.rules.DoublePunctuationRule;
import org.languagetool.rules.Rule;
import org.languagetool.rules.SentenceWhitespaceRule;
import org.languagetool.rules.UppercaseSentenceStartRule;
import org.languagetool.rules.WhitespaceRule;
import org.languagetool.rules.WordRepeatRule;
import org.languagetool.rules.pl.CompoundRule;
import org.languagetool.rules.pl.MorfologikPolishSpellerRule;
import org.languagetool.rules.pl.PolishUnpairedBracketsRule;
import org.languagetool.rules.pl.PolishWordRepeatRule;
import org.languagetool.rules.pl.SimpleReplaceRule;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.synthesis.pl.PolishSynthesizer;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tagging.disambiguation.pl.PolishHybridDisambiguator;
import org.languagetool.tagging.pl.PolishTagger;
import org.languagetool.tokenizers.SRXSentenceTokenizer;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tokenizers.WordTokenizer;
import org.languagetool.tokenizers.pl.PolishWordTokenizer;

public class Polish
extends Language {
    private Tagger tagger;
    private SentenceTokenizer sentenceTokenizer;
    private PolishWordTokenizer wordTokenizer = new PolishWordTokenizer();
    private Disambiguator disambiguator;
    private Synthesizer synthesizer;

    public Polish() {
        this.wordTokenizer.setTagger(this.getTagger());
    }

    public String getName() {
        return "Polish";
    }

    public String getShortName() {
        return "pl";
    }

    public String[] getCountries() {
        return new String[]{"PL"};
    }

    public Tagger getTagger() {
        if (this.tagger == null) {
            this.tagger = new PolishTagger();
        }
        return this.tagger;
    }

    public SentenceTokenizer getSentenceTokenizer() {
        if (this.sentenceTokenizer == null) {
            this.sentenceTokenizer = new SRXSentenceTokenizer((Language)this);
        }
        return this.sentenceTokenizer;
    }

    public final WordTokenizer getWordTokenizer() {
        if (this.wordTokenizer == null) {
            this.wordTokenizer = new PolishWordTokenizer();
        }
        return this.wordTokenizer;
    }

    public Disambiguator getDisambiguator() {
        if (this.disambiguator == null) {
            this.disambiguator = new PolishHybridDisambiguator();
        }
        return this.disambiguator;
    }

    public Synthesizer getSynthesizer() {
        if (this.synthesizer == null) {
            this.synthesizer = new PolishSynthesizer();
        }
        return this.synthesizer;
    }

    public Contributor[] getMaintainers() {
        return new Contributor[]{Contributors.MARCIN_MILKOWSKI};
    }

    public List<Class<? extends Rule>> getRelevantRules() {
        return Arrays.asList(CommaWhitespaceRule.class, DoublePunctuationRule.class, UppercaseSentenceStartRule.class, WordRepeatRule.class, WhitespaceRule.class, SentenceWhitespaceRule.class, PolishUnpairedBracketsRule.class, MorfologikPolishSpellerRule.class, PolishWordRepeatRule.class, CompoundRule.class, SimpleReplaceRule.class);
    }
}

