/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.nl;

import java.io.IOException;
import java.util.Locale;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.language.Dutch;
import org.languagetool.rules.AbstractSimpleReplaceRule2;
import org.languagetool.rules.Category;
import org.languagetool.rules.CategoryId;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;

public class SimpleReplaceRule
extends AbstractSimpleReplaceRule2 {
    public static final String DUTCH_SIMPLE_REPLACE_RULE = "NL_SIMPLE_REPLACE";
    private static final Locale NL_LOCALE = new Locale("nl");

    public SimpleReplaceRule(ResourceBundle messages) throws IOException {
        super(messages, (Language)new Dutch());
        this.setLocQualityIssueType(ITSIssueType.Misspelling);
        this.setCategory(new Category(new CategoryId("VERGISSINGEN"), "Vergissingen"));
        this.addExamplePair(Example.wrong((String)"<marker>ofzo</marker>."), Example.fixed((String)"<marker>of zo</marker>."));
    }

    public String getFileName() {
        return "/nl/replace.txt";
    }

    public final String getId() {
        return DUTCH_SIMPLE_REPLACE_RULE;
    }

    public String getDescription() {
        return "Snelle correctie van veel voorkomende vergissingen";
    }

    public String getShort() {
        return "Vergissing";
    }

    public String getSuggestion() {
        return " zou fout kunnen zijn. Misschien bedoelt u: ";
    }

    public String getSuggestionsSeparator() {
        return ", ";
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public Locale getLocale() {
        return NL_LOCALE;
    }
}

