/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.nl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import org.jetbrains.annotations.NotNull;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.rules.Rule;
import org.languagetool.rules.nl.PreferredWordRuleWithSuggestion;
import org.languagetool.rules.patterns.PatternRule;
import org.languagetool.rules.patterns.PatternToken;
import org.languagetool.rules.patterns.PatternTokenBuilder;

class PreferredWordData {
    private final List<PreferredWordRuleWithSuggestion> spellingRules = new ArrayList<PreferredWordRuleWithSuggestion>();

    PreferredWordData(String ruleDesc) {
        String filePath = "/nl/preferredwords.csv";
        try (InputStream inputStream = JLanguageTool.getDataBroker().getFromResourceDirAsStream(filePath);
             Scanner scanner = new Scanner(inputStream, "utf-8");){
            Language dutch = Languages.getLanguageForShortCode((String)"nl");
            String message = "Voor dit woord is een gebruikelijker alternatief.";
            String shortMessage = "Gebruikelijker woord";
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (line.startsWith("#")) continue;
                String[] parts = line.split(";");
                if (parts.length != 2) {
                    throw new RuntimeException("Unexpected format in file " + filePath + ": " + line);
                }
                String oldWord = parts[0];
                String newWord = parts[1];
                List<PatternToken> patternTokens = this.getTokens(oldWord, dutch);
                PatternRule rule = new PatternRule("NL_PREFERRED_WORD_RULE_INTERNAL", dutch, patternTokens, ruleDesc, message, shortMessage);
                this.spellingRules.add(new PreferredWordRuleWithSuggestion((Rule)rule, oldWord, newWord));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    private List<PatternToken> getTokens(String oldWord, Language lang) {
        PatternTokenBuilder builder = new PatternTokenBuilder();
        String[] newWordTokens = oldWord.split(" ");
        ArrayList<PatternToken> patternTokens = new ArrayList<PatternToken>();
        for (String part : newWordTokens) {
            PatternToken token = this.isBaseform(oldWord, lang) ? builder.csToken(part).matchInflectedForms().build() : builder.csToken(part).build();
            patternTokens.add(token);
        }
        return patternTokens;
    }

    private boolean isBaseform(String term, Language lang) {
        try {
            AnalyzedTokenReadings lookup = (AnalyzedTokenReadings)lang.getTagger().tag(Collections.singletonList(term)).get(0);
            if (lookup != null) {
                return lookup.hasLemma(term);
            }
            return false;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<PreferredWordRuleWithSuggestion> get() {
        return this.spellingRules;
    }
}

