/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.nl;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.languagetool.rules.AbstractSimpleReplaceRule;
import org.languagetool.rules.Category;
import org.languagetool.rules.CategoryId;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;

public class SimpleReplaceRule
extends AbstractSimpleReplaceRule {
    public static final String DUTCH_SIMPLE_REPLACE_RULE = "NL_SIMPLE_REPLACE";
    private static final Map<String, List<String>> wrongWords = SimpleReplaceRule.load((String)"/nl/replace.txt");
    private static final Locale NL_LOCALE = new Locale("nl");

    protected Map<String, List<String>> getWrongWords() {
        return wrongWords;
    }

    public SimpleReplaceRule(ResourceBundle messages) throws IOException {
        super(messages);
        this.setLocQualityIssueType(ITSIssueType.Misspelling);
        this.setCategory(new Category(new CategoryId("VERGISSINGEN"), "Vergissingen"));
        this.setCheckLemmas(false);
        this.addExamplePair(Example.wrong((String)"<marker>ofzo</marker>."), Example.fixed((String)"<marker>of zo</marker>."));
    }

    public final String getId() {
        return DUTCH_SIMPLE_REPLACE_RULE;
    }

    public String getDescription() {
        return "Snelle correctie van veel voorkomende vergissingen";
    }

    public String getShort() {
        return "Vergissing";
    }

    public String getMessage(String tokenStr, List<String> replacements) {
        return tokenStr + " is een fout, juist is: " + String.join((CharSequence)", ", replacements) + ".";
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public Locale getLocale() {
        return NL_LOCALE;
    }
}

