/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.util.Arrays;
import java.util.List;
import org.languagetool.Language;
import org.languagetool.language.Contributor;
import org.languagetool.rules.CommaWhitespaceRule;
import org.languagetool.rules.DoublePunctuationRule;
import org.languagetool.rules.GenericUnpairedBracketsRule;
import org.languagetool.rules.Rule;
import org.languagetool.rules.UppercaseSentenceStartRule;
import org.languagetool.rules.WhitespaceRule;
import org.languagetool.rules.nl.CompoundRule;
import org.languagetool.rules.nl.DutchWrongWordInContextRule;
import org.languagetool.rules.nl.MorfologikDutchSpellerRule;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.synthesis.nl.DutchSynthesizer;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tagging.disambiguation.rules.nl.DutchRuleDisambiguator;
import org.languagetool.tagging.nl.DutchTagger;
import org.languagetool.tokenizers.SRXSentenceTokenizer;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tokenizers.Tokenizer;
import org.languagetool.tokenizers.nl.DutchWordTokenizer;

public class Dutch
extends Language {
    private Tagger tagger;
    private SentenceTokenizer sentenceTokenizer;
    private Synthesizer synthesizer;
    private Disambiguator disambiguator;
    private Tokenizer wordTokenizer;

    public final String getName() {
        return "Dutch";
    }

    public final String getShortName() {
        return "nl";
    }

    public final String[] getCountryVariants() {
        return new String[]{"NL", "BE"};
    }

    public String[] getUnpairedRuleStartSymbols() {
        return new String[]{"[", "(", "{", "\u201c", "\u2039", "\u201c", "\u201e"};
    }

    public String[] getUnpairedRuleEndSymbols() {
        return new String[]{"]", ")", "}", "\u201d", "\u203a", "\u201d", "\u201d"};
    }

    public final Tagger getTagger() {
        if (this.tagger == null) {
            this.tagger = new DutchTagger();
        }
        return this.tagger;
    }

    public final Synthesizer getSynthesizer() {
        if (this.synthesizer == null) {
            this.synthesizer = new DutchSynthesizer();
        }
        return this.synthesizer;
    }

    public final SentenceTokenizer getSentenceTokenizer() {
        if (this.sentenceTokenizer == null) {
            this.sentenceTokenizer = new SRXSentenceTokenizer((Language)this);
        }
        return this.sentenceTokenizer;
    }

    public final Tokenizer getWordTokenizer() {
        if (this.wordTokenizer == null) {
            this.wordTokenizer = new DutchWordTokenizer();
        }
        return this.wordTokenizer;
    }

    public final Disambiguator getDisambiguator() {
        if (this.disambiguator == null) {
            this.disambiguator = new DutchRuleDisambiguator();
        }
        return this.disambiguator;
    }

    public final Contributor[] getMaintainers() {
        Contributor contributor = new Contributor("OpenTaal");
        contributor.setUrl("http://www.opentaal.org");
        return new Contributor[]{contributor};
    }

    public List<Class<? extends Rule>> getRelevantRules() {
        return Arrays.asList(CommaWhitespaceRule.class, DoublePunctuationRule.class, GenericUnpairedBracketsRule.class, UppercaseSentenceStartRule.class, MorfologikDutchSpellerRule.class, WhitespaceRule.class, CompoundRule.class, DutchWrongWordInContextRule.class);
    }
}

