/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.language.Contributor;
import org.languagetool.rules.DoublePunctuationRule;
import org.languagetool.rules.MultipleWhitespaceRule;
import org.languagetool.rules.Rule;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.ja.JapaneseTagger;
import org.languagetool.tokenizers.SRXSentenceTokenizer;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tokenizers.Tokenizer;
import org.languagetool.tokenizers.ja.JapaneseWordTokenizer;

public class Japanese
extends Language {
    private Tagger tagger;
    private SentenceTokenizer sentenceTokenizer;

    public String getShortCode() {
        return "ja";
    }

    public String getName() {
        return "Japanese";
    }

    public String[] getCountries() {
        return new String[]{"JP"};
    }

    public Contributor[] getMaintainers() {
        return new Contributor[]{new Contributor("Takahiro Shinkai")};
    }

    public List<Rule> getRelevantRules(ResourceBundle messages, UserConfig userConfig, List<Language> altLanguages) {
        return Arrays.asList(new DoublePunctuationRule(messages), new MultipleWhitespaceRule(messages, (Language)this));
    }

    public Tagger getTagger() {
        if (this.tagger == null) {
            this.tagger = new JapaneseTagger();
        }
        return this.tagger;
    }

    public Tokenizer getWordTokenizer() {
        return new JapaneseWordTokenizer();
    }

    public SentenceTokenizer getSentenceTokenizer() {
        if (this.sentenceTokenizer == null) {
            this.sentenceTokenizer = new SRXSentenceTokenizer((Language)this);
        }
        return this.sentenceTokenizer;
    }
}

