/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.util.Arrays;
import java.util.List;
import org.languagetool.Language;
import org.languagetool.language.Contributor;
import org.languagetool.rules.DoublePunctuationRule;
import org.languagetool.rules.Rule;
import org.languagetool.rules.WhitespaceRule;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.ja.JapaneseTagger;
import org.languagetool.tokenizers.SRXSentenceTokenizer;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tokenizers.Tokenizer;
import org.languagetool.tokenizers.ja.JapaneseWordTokenizer;

public class Japanese
extends Language {
    private Tagger tagger;
    private SentenceTokenizer sentenceTokenizer;

    public String getShortName() {
        return "ja";
    }

    public String getName() {
        return "Japanese";
    }

    public String[] getCountries() {
        return new String[]{"JP"};
    }

    public Contributor[] getMaintainers() {
        return new Contributor[]{new Contributor("Takahiro Shinkai")};
    }

    public List<Class<? extends Rule>> getRelevantRules() {
        return Arrays.asList(DoublePunctuationRule.class, WhitespaceRule.class);
    }

    public final Tagger getTagger() {
        if (this.tagger == null) {
            this.tagger = new JapaneseTagger();
        }
        return this.tagger;
    }

    public final Tokenizer getWordTokenizer() {
        return new JapaneseWordTokenizer();
    }

    public final SentenceTokenizer getSentenceTokenizer() {
        if (this.sentenceTokenizer == null) {
            this.sentenceTokenizer = new SRXSentenceTokenizer((Language)this);
        }
        return this.sentenceTokenizer;
    }
}

