/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.LanguageMaintainedState;
import org.languagetool.UserConfig;
import org.languagetool.language.Contributor;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.CommaWhitespaceRule;
import org.languagetool.rules.DoublePunctuationRule;
import org.languagetool.rules.GenericUnpairedBracketsRule;
import org.languagetool.rules.MultipleWhitespaceRule;
import org.languagetool.rules.Rule;
import org.languagetool.rules.UppercaseSentenceStartRule;
import org.languagetool.rules.WhitespaceBeforePunctuationRule;
import org.languagetool.rules.it.ItalianConfusionProbabilityRule;
import org.languagetool.rules.it.ItalianWordRepeatRule;
import org.languagetool.rules.it.MorfologikItalianSpellerRule;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tagging.disambiguation.rules.it.ItalianRuleDisambiguator;
import org.languagetool.tagging.it.ItalianTagger;
import org.languagetool.tokenizers.SRXSentenceTokenizer;
import org.languagetool.tokenizers.SentenceTokenizer;

public class Italian
extends Language
implements AutoCloseable {
    private Tagger tagger;
    private SentenceTokenizer sentenceTokenizer;
    private LanguageModel languageModel;
    private Disambiguator disambiguator;

    public String getName() {
        return "Italian";
    }

    public String getShortCode() {
        return "it";
    }

    public String[] getCountries() {
        return new String[]{"IT", "CH"};
    }

    public Tagger getTagger() {
        if (this.tagger == null) {
            this.tagger = new ItalianTagger();
        }
        return this.tagger;
    }

    public SentenceTokenizer getSentenceTokenizer() {
        if (this.sentenceTokenizer == null) {
            this.sentenceTokenizer = new SRXSentenceTokenizer((Language)this);
        }
        return this.sentenceTokenizer;
    }

    public Contributor[] getMaintainers() {
        Contributor contributor = new Contributor("Paolo Bianchini");
        return new Contributor[]{contributor};
    }

    public List<Rule> getRelevantRules(ResourceBundle messages, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
        return Arrays.asList(new Rule[]{new WhitespaceBeforePunctuationRule(messages), new CommaWhitespaceRule(messages), new DoublePunctuationRule(messages), new GenericUnpairedBracketsRule(messages, Arrays.asList("[", "(", "{", "\u00bb", "\u00ab"), Arrays.asList("]", ")", "}", "\u00ab", "\u00bb")), new MorfologikItalianSpellerRule(messages, this, userConfig, altLanguages), new UppercaseSentenceStartRule(messages, (Language)this), new ItalianWordRepeatRule(messages, this), new MultipleWhitespaceRule(messages, (Language)this)});
    }

    public synchronized LanguageModel getLanguageModel(File indexDir) throws IOException {
        this.languageModel = this.initLanguageModel(indexDir, this.languageModel);
        return this.languageModel;
    }

    public List<Rule> getRelevantLanguageModelRules(ResourceBundle messages, LanguageModel languageModel) throws IOException {
        return Arrays.asList(new Rule[]{new ItalianConfusionProbabilityRule(messages, languageModel, this)});
    }

    @Override
    public void close() throws Exception {
        if (this.languageModel != null) {
            this.languageModel.close();
        }
    }

    public final Disambiguator getDisambiguator() {
        if (this.disambiguator == null) {
            this.disambiguator = new ItalianRuleDisambiguator();
        }
        return this.disambiguator;
    }

    public LanguageMaintainedState getMaintainedState() {
        return LanguageMaintainedState.ActivelyMaintained;
    }
}

