/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.gl;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.language.Galician;
import org.languagetool.rules.AbstractSimpleReplaceRule2;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.tools.Tools;

public class GalicianBarbarismsRule
extends AbstractSimpleReplaceRule2 {
    public static final String GALICIAN_BARBARISM_RULE = "GL_BARBARISM_REPLACE";
    private static final String FILE_NAME = "/gl/barbarisms.txt";
    private static final Locale GL_LOCALE = new Locale("gl");

    public final List<String> getFileNames() {
        return Collections.singletonList(FILE_NAME);
    }

    public GalicianBarbarismsRule(ResourceBundle messages) throws IOException {
        super(messages, (Language)new Galician());
        this.setCategory(Categories.STYLE.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.LocaleViolation);
        this.addExamplePair(Example.wrong((String)"<marker>curriculum vitae</marker>"), Example.fixed((String)"<marker>curr\u00edculo</marker>"));
    }

    public final String getId() {
        return GALICIAN_BARBARISM_RULE;
    }

    public String getDescription() {
        return "Palabras de orixe estranxeira evit\u00e1beis";
    }

    public String getShort() {
        return "Xenismo";
    }

    public String getMessage() {
        return "'$match' \u00e9 un xenismo. \u00c9 prefer\u00edbel dicir $suggestions";
    }

    public String getSuggestionsSeparator() {
        return " ou ";
    }

    public URL getUrl() {
        return Tools.getUrl((String)"https://gl.wikipedia.org/wiki/Xenismo");
    }

    public Locale getLocale() {
        return GL_LOCALE;
    }
}

