/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.gl;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.language.Galician;
import org.languagetool.rules.AbstractSimpleReplaceRule2;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.tools.Tools;

public class GalicianRedundancyRule
extends AbstractSimpleReplaceRule2 {
    public static final String GL_REDUNDANCY_REPLACE = "GL_REDUNDANCY_REPLACE";
    private static final String FILE_NAME = "/gl/redundancies.txt";
    private static final Locale GL_LOCALE = new Locale("gl");

    public final List<String> getFileNames() {
        return Collections.singletonList(FILE_NAME);
    }

    public GalicianRedundancyRule(ResourceBundle messages) throws IOException {
        super(messages, (Language)new Galician());
        super.setCategory(Categories.REDUNDANCY.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Style);
        this.addExamplePair(Example.wrong((String)"<marker>duna de area</marker>"), Example.fixed((String)"<marker>duna</marker>"));
    }

    public final String getId() {
        return GL_REDUNDANCY_REPLACE;
    }

    public String getDescription() {
        return "1. Pleonasmos e redundancias";
    }

    public String getShort() {
        return "Pleonasmo";
    }

    public String getSuggestion() {
        return "'$match' \u00e9 un pleonasmo. \u00c9 preferible dicir $suggestions";
    }

    public String getSuggestionsSeparator() {
        return " ou ";
    }

    public URL getUrl() {
        return Tools.getUrl((String)"https://gl.wikipedia.org/wiki/Pleonasmo");
    }

    public Locale getLocale() {
        return GL_LOCALE;
    }
}

