/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ga;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.rules.AbstractSimpleReplaceRule;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ITSIssueType;

public class SpacesRule
extends AbstractSimpleReplaceRule {
    private static final Map<String, List<String>> wrongWords = SpacesRule.loadFromPath((String)"/ga/spaces.txt");
    private static final Locale GA_LOCALE = new Locale("GA");

    public Map<String, List<String>> getWrongWords() {
        return wrongWords;
    }

    public SpacesRule(ResourceBundle messages, Language language) throws IOException {
        super(messages, language);
        super.setCategory(Categories.TYPOS.getCategory(messages));
        super.setLocQualityIssueType(ITSIssueType.Misspelling);
        this.setIgnoreTaggedWords();
        this.setCheckLemmas(false);
    }

    public final String getId() {
        return "GA_SPASANNA";
    }

    public String getDescription() {
        return "Sp\u00e1s ar iarraidh";
    }

    public String getShort() {
        return "Sp\u00e1s ar iarraidh";
    }

    public String getMessage(String tokenStr, List<String> replacements) {
        return "Sp\u00e1s ar iarraidh: \"" + String.join((CharSequence)", ", replacements) + "\".";
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public Locale getLocale() {
        return GA_LOCALE;
    }
}

