/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ga;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.language.Irish;
import org.languagetool.rules.PartialPosTagFilter;

public class IrishPartialPosTagFilter
extends PartialPosTagFilter {
    protected List<AnalyzedTokenReadings> tag(String token) {
        try {
            Irish irishLanguage = Irish.getInstance();
            List tags = irishLanguage.getTagger().tag(Collections.singletonList(token));
            AnalyzedTokenReadings[] atr = tags.toArray(new AnalyzedTokenReadings[tags.size()]);
            AnalyzedSentence disambiguated = irishLanguage.getDisambiguator().disambiguate(new AnalyzedSentence(atr));
            return Arrays.asList(disambiguated.getTokens());
        }
        catch (IOException e) {
            throw new RuntimeException("Could not tag and disambiguate '" + token + "'", e);
        }
    }
}

