/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.fr;

import java.util.Map;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.language.French;
import org.languagetool.rules.AbstractRepeatedWordsRule;
import org.languagetool.rules.SynonymsData;
import org.languagetool.synthesis.FrenchSynthesizer;
import org.languagetool.synthesis.Synthesizer;

public class FrenchRepeatedWordsRule
extends AbstractRepeatedWordsRule {
    private static final Map<String, SynonymsData> wordsToCheck = FrenchRepeatedWordsRule.loadWords((String)"/fr/synonyms.txt");

    public FrenchRepeatedWordsRule(ResourceBundle messages) {
        super(messages, (Language)new French());
    }

    protected String getMessage() {
        return "Ce mot appara\u00eet d\u00e9j\u00e0 dans l'une des phrases pr\u00e9c\u00e9dant imm\u00e9diatement celle-ci. Utilisez un synonyme pour apporter plus de vari\u00e9t\u00e9 \u00e0 votre texte, except\u00e9 si la r\u00e9p\u00e9tition est intentionnelle.";
    }

    public String getDescription() {
        return "Synonymes de mots r\u00e9p\u00e9t\u00e9s.";
    }

    protected Map<String, SynonymsData> getWordsToCheck() {
        return wordsToCheck;
    }

    protected String getShortMessage() {
        return "Style : Mot r\u00e9p\u00e9t\u00e9";
    }

    protected Synthesizer getSynthesizer() {
        return FrenchSynthesizer.INSTANCE;
    }

    protected String adjustPostag(String postag) {
        if (postag.endsWith("e sp")) {
            return postag.replaceFirst("e sp", ". .*");
        }
        if (postag.endsWith("m s")) {
            return postag.replaceFirst("m s", "[me] sp?");
        }
        if (postag.endsWith("f s")) {
            return postag.replaceFirst("f s", "[fe] sp?");
        }
        if (postag.endsWith("m p")) {
            return postag.replaceFirst("m p", "[me] s?p");
        }
        if (postag.endsWith("f p")) {
            return postag.replaceFirst("f p", "[fe] s?p");
        }
        if (postag.endsWith("e s")) {
            return postag.replaceFirst("e s", "[me] sp?");
        }
        if (postag.endsWith("e p")) {
            return postag.replaceFirst("e p", "[me] s?p");
        }
        if (postag.endsWith("m sp")) {
            return postag.replaceFirst("m sp", "[me] s?p?");
        }
        if (postag.endsWith("f sp")) {
            return postag.replaceFirst("f sp", "[fe] s?p?");
        }
        return postag;
    }

    protected boolean isException(AnalyzedTokenReadings[] tokens, int i, boolean sentStart, boolean isCapitalized, boolean isAllUppercase) {
        if (isAllUppercase || isCapitalized && !sentStart) {
            return true;
        }
        return tokens[i].hasPosTagStartingWith("Z");
    }
}

