/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.fr;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.chunking.ChunkTag;
import org.languagetool.tagging.BaseTagger;
import org.languagetool.tools.StringTools;

public class FrenchTagger
extends BaseTagger {
    public static final FrenchTagger INSTANCE = new FrenchTagger();
    private static final Pattern VERB = Pattern.compile("V .+");
    private static final Pattern PREFIXES_FOR_VERBS = Pattern.compile("(auto|auto-|re-|sur-)([^-].*[aeiou\u00ea\u00e0\u00e9\u00e8\u00ed\u00f2\u00f3\u00ef\u00fc].+[aeiou\u00ea\u00e0\u00e9\u00e8\u00ed\u00f2\u00f3\u00ef\u00fc].*)", 66);
    private static final Pattern NOUN_ADJ = Pattern.compile("[NJ] .+|V ppa.*");
    private static final Pattern PREFIXES_NOUN_ADJ = Pattern.compile("(post-|sur-|mini-|m\u00e9ga-|demi-|p\u00e9ri-|anti-|g\u00e9o-|nord-|sud-|n\u00e9o-|m\u00e9ga-|ultra-|pro-|inter-|micro-|macro-|sous-|haut-|auto-|r\u00e9-|pr\u00e9-|super-|vice-|hyper-|proto-|grand-|pseudo-)(.+)", 66);
    private static final Pattern PREFIXES_FOR_NOUN_ADJ = Pattern.compile("(mini|m\u00e9ga)([^-].*[aeiou\u00ea\u00e0\u00e9\u00e8\u00ed\u00f2\u00f3\u00ef\u00fc].+[aeiou\u00ea\u00e0\u00e9\u00e8\u00ed\u00f2\u00f3\u00ef\u00fc].*)", 66);

    public FrenchTagger() {
        super("/fr/french.dict", Locale.FRENCH, false);
    }

    public boolean overwriteWithManualTagger() {
        return false;
    }

    public List<AnalyzedTokenReadings> tag(List<String> sentenceTokens) {
        ArrayList<AnalyzedTokenReadings> tokenReadings = new ArrayList<AnalyzedTokenReadings>();
        int pos = 0;
        for (String word : sentenceTokens) {
            ArrayList<ChunkTag> listChunkTags;
            List<AnalyzedToken> l;
            boolean containsTypewriterApostrophe = false;
            boolean containsTypographicApostrophe = false;
            if (word.length() > 1) {
                if (word.contains("'")) {
                    containsTypewriterApostrophe = true;
                }
                if (word.contains("\u2019")) {
                    containsTypographicApostrophe = true;
                    word = word.replace("\u2019", "'");
                }
            }
            if ((l = this.tagWord(word, word)).isEmpty() && word.toLowerCase().contains("oe")) {
                l = this.tagWord(word.replaceAll("oe", "\u0153").replaceAll("OE", "\u0152"), word);
            }
            if (l.isEmpty()) {
                l.add(new AnalyzedToken(word, null, null));
            }
            AnalyzedTokenReadings atr = new AnalyzedTokenReadings(l, pos);
            if (containsTypewriterApostrophe) {
                listChunkTags = new ArrayList<ChunkTag>();
                listChunkTags.add(new ChunkTag("containsTypewriterApostrophe"));
                atr.setChunkTags(listChunkTags);
            }
            if (containsTypographicApostrophe) {
                listChunkTags = new ArrayList();
                listChunkTags.add(new ChunkTag("containsTypographicApostrophe"));
                atr.setChunkTags(listChunkTags);
            }
            tokenReadings.add(atr);
            pos += word.length();
        }
        return tokenReadings;
    }

    private List<AnalyzedToken> tagWord(String word, String originalWord) {
        ArrayList<AnalyzedToken> l = new ArrayList<AnalyzedToken>();
        String lowerWord = word.toLowerCase(this.locale);
        boolean isLowercase = word.equals(lowerWord);
        boolean isMixedCase = StringTools.isMixedCase((String)word);
        boolean isAllUpper = StringTools.isAllUppercase((String)word);
        List taggerTokens = this.asAnalyzedTokenListForTaggedWords(originalWord, this.getWordTagger().tag(word));
        this.addTokens(taggerTokens, l);
        if (!isLowercase && !isMixedCase) {
            List lowerTaggerTokens = this.asAnalyzedTokenListForTaggedWords(originalWord, this.getWordTagger().tag(lowerWord));
            this.addTokens(lowerTaggerTokens, l);
        }
        if (l.isEmpty() && isAllUpper) {
            String firstUpper = StringTools.uppercaseFirstChar((String)lowerWord);
            List firstupperTaggerTokens = this.asAnalyzedTokenListForTaggedWords(originalWord, this.getWordTagger().tag(firstUpper));
            this.addTokens(firstupperTaggerTokens, l);
        }
        if (l.isEmpty()) {
            this.addTokens(this.additionalTags(word), l);
        }
        return l;
    }

    @Nullable
    protected List<AnalyzedToken> additionalTags(String word) {
        String possibleNoun;
        String lemma;
        Matcher m;
        String posTag;
        List taggerTokens;
        ArrayList<AnalyzedToken> additionalTaggedTokens = new ArrayList<AnalyzedToken>();
        Matcher matcher = PREFIXES_FOR_VERBS.matcher(word);
        if (matcher.matches()) {
            String possibleVerb = matcher.group(2).toLowerCase();
            taggerTokens = this.asAnalyzedTokenListForTaggedWords(word, this.getWordTagger().tag(possibleVerb));
            for (AnalyzedToken taggerToken : taggerTokens) {
                posTag = taggerToken.getPOSTag();
                if (posTag == null || !(m = VERB.matcher(posTag)).matches()) continue;
                lemma = matcher.group(1).toLowerCase().concat(taggerToken.getLemma());
                additionalTaggedTokens.add(new AnalyzedToken(word, posTag, lemma));
            }
            if (!additionalTaggedTokens.isEmpty()) {
                return additionalTaggedTokens;
            }
        }
        if ((matcher = PREFIXES_FOR_NOUN_ADJ.matcher(word)).matches()) {
            possibleNoun = matcher.group(2).toLowerCase();
            taggerTokens = this.asAnalyzedTokenListForTaggedWords(word, this.getWordTagger().tag(possibleNoun));
            for (AnalyzedToken taggerToken : taggerTokens) {
                posTag = taggerToken.getPOSTag();
                if (posTag == null || !(m = NOUN_ADJ.matcher(posTag)).matches()) continue;
                lemma = matcher.group(1).toLowerCase().concat(taggerToken.getLemma());
                additionalTaggedTokens.add(new AnalyzedToken(word, posTag, lemma));
            }
            if (!additionalTaggedTokens.isEmpty()) {
                return additionalTaggedTokens;
            }
        }
        if ((matcher = PREFIXES_NOUN_ADJ.matcher(word)).matches()) {
            possibleNoun = matcher.group(2).toLowerCase();
            taggerTokens = this.asAnalyzedTokenListForTaggedWords(word, this.getWordTagger().tag(possibleNoun));
            for (AnalyzedToken taggerToken : taggerTokens) {
                posTag = taggerToken.getPOSTag();
                if (posTag == null || !(m = NOUN_ADJ.matcher(posTag)).matches()) continue;
                lemma = matcher.group(1).toLowerCase().concat(taggerToken.getLemma());
                additionalTaggedTokens.add(new AnalyzedToken(word, posTag, lemma));
            }
            if (additionalTaggedTokens.isEmpty()) {
                taggerTokens = this.asAnalyzedTokenListForTaggedWords(word, this.getWordTagger().tag(possibleNoun.toLowerCase()));
                for (AnalyzedToken taggerToken : taggerTokens) {
                    posTag = taggerToken.getPOSTag();
                    if (posTag == null || !(m = NOUN_ADJ.matcher(posTag)).matches()) continue;
                    lemma = matcher.group(1).toLowerCase().concat(taggerToken.getLemma());
                    additionalTaggedTokens.add(new AnalyzedToken(word, posTag, lemma));
                }
            }
            return additionalTaggedTokens;
        }
        return null;
    }

    private void addTokens(List<AnalyzedToken> taggedTokens, List<AnalyzedToken> l) {
        if (taggedTokens != null) {
            l.addAll(taggedTokens);
        }
    }
}

