/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.fr;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.languagetool.rules.AbstractSimpleReplaceRule;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ITSIssueType;

public class SimpleReplaceRule
extends AbstractSimpleReplaceRule {
    private static final Map<String, List<String>> wrongWords = SimpleReplaceRule.loadFromPath((String[])new String[]{"/fr/replace.txt", "/fr/replace_custom.txt"});
    private static final Locale FR_LOCALE = new Locale("FR");

    protected Map<String, List<String>> getWrongWords() {
        return wrongWords;
    }

    public SimpleReplaceRule(ResourceBundle messages) throws IOException {
        super(messages);
        super.setCategory(Categories.TYPOS.getCategory(messages));
        super.setLocQualityIssueType(ITSIssueType.Misspelling);
        this.setIgnoreTaggedWords();
        this.setCheckLemmas(false);
    }

    public final String getId() {
        return "FR_SIMPLE_REPLACE";
    }

    public String getDescription() {
        return "Recherche les mots/phrases incorrects";
    }

    public String getShort() {
        return "Mot incorrect";
    }

    public String getMessage(String tokenStr, List<String> replacements) {
        if (replacements.size() > 0) {
            return "Vouliez-vous dire \u00ab " + replacements.get(0) + " \u00bb ?";
        }
        return this.getShort();
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public Locale getLocale() {
        return FR_LOCALE;
    }
}

