/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.fr;

import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.tools.StringTools;

public class QuestionWhitespaceRule
extends Rule {
    private static final Pattern urlPattern = Pattern.compile("^(file|s?ftp|finger|git|gopher|hdl|https?|shttp|imap|mailto|mms|nntp|s?news(post|reply)?|prospero|rsync|rtspu|sips?|svn|svn\\+ssh|telnet|wais)$");

    public QuestionWhitespaceRule(ResourceBundle messages) {
        super.setCategory(Categories.MISC.getCategory(messages));
    }

    public String getId() {
        return "FRENCH_WHITESPACE";
    }

    public String getDescription() {
        return "Insertion des espaces fines ins\u00e9cables";
    }

    public RuleMatch[] match(AnalyzedSentence sentence) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = sentence.getTokens();
        String prevToken = "";
        for (int i = 1; i < tokens.length; ++i) {
            String token = tokens[i].getToken();
            boolean isWhiteBefore = tokens[i].isWhitespaceBefore() && !"\u00a0".equals(prevToken) && !"\u202f".equals(prevToken);
            String msg = null;
            int fixLen = 0;
            String suggestionText = null;
            if (isWhiteBefore) {
                switch (token) {
                    case "?": {
                        msg = "Point d'interrogation est pr\u00e9c\u00e9d\u00e9 d'une espace fine ins\u00e9cable.";
                        suggestionText = "\u202f?";
                        fixLen = 1;
                        break;
                    }
                    case "!": {
                        msg = "Point d'exclamation est pr\u00e9c\u00e9d\u00e9 d'une espace fine ins\u00e9cable.";
                        suggestionText = "\u202f!";
                        fixLen = 1;
                        break;
                    }
                    case "\u00bb": {
                        msg = "Le guillemet fermant est pr\u00e9c\u00e9d\u00e9 d'une espace ins\u00e9cable.";
                        suggestionText = "\u00a0\u00bb";
                        fixLen = 1;
                        break;
                    }
                    case ";": {
                        msg = "Point-virgule est pr\u00e9c\u00e9d\u00e9 d'une espace fine ins\u00e9cable.";
                        suggestionText = "\u202f;";
                        fixLen = 1;
                        break;
                    }
                    case ":": {
                        msg = "Deux-points sont pr\u00e9c\u00e9d\u00e9 d'une espace ins\u00e9cable.";
                        suggestionText = "\u00a0:";
                        fixLen = 1;
                    }
                }
            } else if (token.equals("?") && !prevToken.equals("!") && !prevToken.equals("\u00a0") && !prevToken.equals("\u202f")) {
                msg = "Point d'interrogation est pr\u00e9c\u00e9d\u00e9 d'une espace fine ins\u00e9cable.";
                suggestionText = prevToken + "\u202f?";
                fixLen = 1;
            } else if (token.equals("!") && !prevToken.equals("?") && !prevToken.equals("\u00a0") && !prevToken.equals("\u202f")) {
                msg = "Point d'exclamation est pr\u00e9c\u00e9d\u00e9 d'une espace fine ins\u00e9cable.";
                suggestionText = prevToken + "\u202f!";
                fixLen = 1;
            } else if (token.equals(";") && !prevToken.equals("\u00a0") && !prevToken.equals("\u202f")) {
                msg = "Point-virgule est pr\u00e9c\u00e9d\u00e9 d'une espace fine ins\u00e9cable.";
                suggestionText = prevToken + "\u202f;";
                fixLen = 1;
            } else if (token.equals(":") && !prevToken.equals("\u00a0") && !prevToken.equals("\u202f")) {
                Matcher matcherUrl = urlPattern.matcher(prevToken);
                if (!matcherUrl.find()) {
                    msg = "Deux-points pr\u00e9c\u00e9d\u00e9s d'une espace ins\u00e9cable.";
                    suggestionText = prevToken + "\u00a0:";
                    fixLen = 1;
                }
            } else if (token.equals("\u00bb") && !prevToken.equals("\u00a0") && !prevToken.equals("\u202f")) {
                msg = "Le guillemet fermant est pr\u00e9c\u00e9d\u00e9 d'une espace ins\u00e9cable.";
                suggestionText = prevToken + "\u00a0\u00bb";
                fixLen = 1;
            }
            if (StringTools.isEmpty((String)token) && prevToken.equals("\u00ab")) {
                msg = "Le guillemet ouvrant est suivi d'une espace ins\u00e9cable.";
                suggestionText = "\u00ab\u00a0";
                fixLen = 1;
            } else if (!StringTools.isEmpty((String)token) && prevToken.equals("\u00ab") && !token.equals("\u00a0") && !token.equals("\u202f")) {
                msg = "Le guillemet ouvrant est suivi d'une espace ins\u00e9cable.";
                suggestionText = "\u00ab\u00a0";
                fixLen = 0;
            }
            if (msg != null) {
                int fromPos = tokens[i - 1].getStartPos();
                int toPos = tokens[i - 1].getStartPos() + fixLen + tokens[i - 1].getToken().length();
                RuleMatch ruleMatch = new RuleMatch((Rule)this, fromPos, toPos, msg, "Ins\u00e9rer un espace ins\u00e9cable");
                if (suggestionText != null) {
                    ruleMatch.setSuggestedReplacement(suggestionText);
                }
                ruleMatches.add(ruleMatch);
            }
            prevToken = token;
        }
        return this.toRuleMatchArray(ruleMatches);
    }
}

