/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.fr;

import java.util.Calendar;
import java.util.Locale;
import org.languagetool.rules.AbstractDateCheckFilter;

public class DateCheckFilter
extends AbstractDateCheckFilter {
    protected Calendar getCalendar() {
        return Calendar.getInstance(Locale.FRENCH);
    }

    protected int getDayOfWeek(String dayStr) {
        String day = dayStr.toLowerCase();
        if (day.startsWith("dim")) {
            return 1;
        }
        if (day.startsWith("lun")) {
            return 2;
        }
        if (day.startsWith("mar")) {
            return 3;
        }
        if (day.startsWith("mer")) {
            return 4;
        }
        if (day.startsWith("jeu")) {
            return 5;
        }
        if (day.startsWith("ven")) {
            return 6;
        }
        if (day.startsWith("sam")) {
            return 7;
        }
        throw new RuntimeException("Could not find day of week for '" + dayStr + "'");
    }

    protected String getDayOfWeek(Calendar date) {
        return date.getDisplayName(7, 2, Locale.FRENCH);
    }

    protected int getMonth(String monthStr) {
        String mon = monthStr.toLowerCase();
        if (mon.startsWith("jan")) {
            return 1;
        }
        if (mon.startsWith("f\u00e9v")) {
            return 2;
        }
        if (mon.startsWith("mar")) {
            return 3;
        }
        if (mon.startsWith("avr")) {
            return 4;
        }
        if (mon.startsWith("mai")) {
            return 5;
        }
        if (mon.startsWith("jui")) {
            return 6;
        }
        if (mon.startsWith("jui")) {
            return 7;
        }
        if (mon.startsWith("aou") || mon.startsWith("ao\u00fb")) {
            return 8;
        }
        if (mon.startsWith("sep")) {
            return 9;
        }
        if (mon.startsWith("oct")) {
            return 10;
        }
        if (mon.startsWith("nov")) {
            return 11;
        }
        if (mon.startsWith("d\u00e9c")) {
            return 12;
        }
        throw new RuntimeException("Could not find month '" + monthStr + "'");
    }
}

