/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.language.Contributor;
import org.languagetool.rules.CommaWhitespaceRule;
import org.languagetool.rules.DoublePunctuationRule;
import org.languagetool.rules.LongSentenceRule;
import org.languagetool.rules.MultipleWhitespaceRule;
import org.languagetool.rules.Rule;
import org.languagetool.rules.fa.PersianCommaWhitespaceRule;
import org.languagetool.rules.fa.PersianDoublePunctuationRule;
import org.languagetool.rules.fa.PersianSpaceBeforeRule;
import org.languagetool.rules.fa.PersianWordRepeatBeginningRule;
import org.languagetool.rules.fa.PersianWordRepeatRule;
import org.languagetool.rules.fa.SimpleReplaceRule;
import org.languagetool.rules.fa.WordCoherencyRule;
import org.languagetool.tokenizers.PersianWordTokenizer;
import org.languagetool.tokenizers.SRXSentenceTokenizer;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tokenizers.WordTokenizer;

public class Persian
extends Language {
    private SentenceTokenizer sentenceTokenizer;
    private WordTokenizer wordTokenizer;
    private String name = "Persian";

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getShortName() {
        return "fa";
    }

    public String[] getCountries() {
        return new String[]{"IR", "AF"};
    }

    public SentenceTokenizer getSentenceTokenizer() {
        if (this.sentenceTokenizer == null) {
            this.sentenceTokenizer = new SRXSentenceTokenizer((Language)this);
        }
        return this.sentenceTokenizer;
    }

    public WordTokenizer getWordTokenizer() {
        if (this.wordTokenizer == null) {
            this.wordTokenizer = new PersianWordTokenizer();
        }
        return this.wordTokenizer;
    }

    public Contributor[] getMaintainers() {
        return new Contributor[]{new Contributor("Reza1615"), new Contributor("Alireza Eskandarpour Shoferi"), new Contributor("Ebrahim Byagowi")};
    }

    public List<Rule> getRelevantRules(ResourceBundle messages) throws IOException {
        return Arrays.asList(new Rule[]{new CommaWhitespaceRule(messages), new DoublePunctuationRule(messages), new MultipleWhitespaceRule(messages, (Language)this), new LongSentenceRule(messages), new PersianCommaWhitespaceRule(messages), new PersianDoublePunctuationRule(messages), new PersianWordRepeatBeginningRule(messages, this), new PersianWordRepeatRule(messages, this), new SimpleReplaceRule(messages), new PersianSpaceBeforeRule(messages, this), new WordCoherencyRule(messages)});
    }
}

