/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.es;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.TextLevelRule;

public class QuestionMarkRule
extends TextLevelRule {
    public QuestionMarkRule(ResourceBundle messages) {
        super(messages);
        super.setCategory(Categories.TYPOGRAPHY.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Typographical);
        this.addExamplePair(Example.wrong((String)"<marker>Que</marker> pasa?"), Example.fixed((String)"<marker>\u00bfQue</marker> pasa?"));
    }

    public int minToCheckParagraph() {
        return 1;
    }

    public final String getId() {
        return "ES_QUESTION_MARK";
    }

    public String getDescription() {
        return "Signos de exclamaci\u00f3n / interrogaci\u00f3n desparejados";
    }

    public RuleMatch[] match(List<AnalyzedSentence> sentences) {
        ArrayList<RuleMatch> matches = new ArrayList<RuleMatch>();
        boolean prevSentEndsWithColon = false;
        int pos = 0;
        for (AnalyzedSentence sentence : sentences) {
            AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
            boolean needsInvQuestionMark = this.hasTokenAtEnd("?", tokens);
            boolean needsInvExclMark = this.hasTokenAtEnd("!", tokens);
            boolean endsWithColon = this.hasTokenAtEnd(":", tokens);
            if (needsInvQuestionMark || needsInvExclMark) {
                boolean hasInvQuestionMark = false;
                boolean hasInvExlcMark = false;
                AnalyzedTokenReadings firstToken = null;
                for (int i = 0; i < tokens.length; ++i) {
                    if (firstToken == null && !tokens[i].isSentenceStart()) {
                        firstToken = tokens[i];
                    }
                    if (tokens[i].getToken().equals("\u00bf")) {
                        hasInvQuestionMark = true;
                    } else if (tokens[i].getToken().equals("\u00a1")) {
                        hasInvExlcMark = true;
                    }
                    if (i <= 2 || i + 1 >= tokens.length) continue;
                    if (tokens[i - 1].getToken().equals(",") && tokens[i].hasPosTag("SPS00") && (tokens[i + 1].hasPosTagStartingWith("PT") || tokens[i + 1].hasPosTagStartingWith("DT"))) {
                        firstToken = tokens[i];
                    }
                    if (!tokens[i - 1].getToken().equals(",") || !tokens[i].hasPosTagStartingWith("PT") && !tokens[i].hasPosTagStartingWith("DT")) continue;
                    firstToken = tokens[i];
                }
                if (firstToken != null) {
                    String s = null;
                    if (!needsInvQuestionMark || !needsInvExclMark) {
                        if (needsInvQuestionMark && !hasInvQuestionMark) {
                            s = "\u00bf";
                        } else if (needsInvExclMark && !hasInvExlcMark) {
                            s = "\u00a1";
                        }
                    }
                    if (s != null && !prevSentEndsWithColon) {
                        String message = "S\u00edmbolo desparejado: Parece que falta un '" + s + "'";
                        RuleMatch match = new RuleMatch((Rule)this, sentence, pos + firstToken.getStartPos(), pos + firstToken.getEndPos(), message);
                        match.setSuggestedReplacement(s + firstToken.getToken());
                        matches.add(match);
                    }
                }
            }
            pos += sentence.getCorrectedTextLength();
            prevSentEndsWithColon = endsWithColon;
        }
        return this.toRuleMatchArray(matches);
    }

    private boolean hasTokenAtEnd(String ch, AnalyzedTokenReadings[] tokens) {
        if (tokens[tokens.length - 1].isParagraphEnd() && !tokens[tokens.length - 1].getToken().equals(ch) && tokens.length >= 2) {
            return tokens[tokens.length - 2].getToken().equals(ch);
        }
        return tokens[tokens.length - 1].getToken().equals(ch);
    }
}

