/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.es;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.rules.SuggestedReplacement;
import org.languagetool.rules.spelling.morfologik.MorfologikSpellerRule;
import org.languagetool.tagging.es.SpanishTagger;

public class MorfologikSpanishSpellerRule
extends MorfologikSpellerRule {
    private static final Pattern PREFIX_WITH_WHITESPACE = Pattern.compile("^(tele|anti|auto|ex|extra|macro|mega|meta|micro|multi|mono|mini|post|retro|semi|super|hiper|trans|re|g) (..+)|.+ s$", 66);
    private static final Pattern PARTICULA_FINAL = Pattern.compile("^(..+) (que|cual)$", 66);
    private static final Pattern SPLIT_SUGGESTIONS = Pattern.compile("^(..+\\p{L}|en|de|del|al|a|y|o|con)(\\d+)$", 66);
    private static final Pattern ANY_TAG = Pattern.compile("[NVACPDRS].*");
    private static final SpanishTagger tagger = SpanishTagger.INSTANCE;

    public MorfologikSpanishSpellerRule(ResourceBundle messages, Language language, UserConfig userConfig, List<Language> altLanguages) throws IOException {
        super(messages, language, userConfig, altLanguages);
        this.setIgnoreTaggedWords();
    }

    public String getFileName() {
        return "/es/es-ES.dict";
    }

    public final String getId() {
        return "MORFOLOGIK_RULE_ES";
    }

    public boolean useInOffice() {
        return true;
    }

    protected List<SuggestedReplacement> orderSuggestions(List<SuggestedReplacement> suggestions, String word) {
        ArrayList<SuggestedReplacement> newSuggestions = new ArrayList<SuggestedReplacement>();
        for (int i = 0; i < suggestions.size(); ++i) {
            if (PREFIX_WITH_WHITESPACE.matcher(suggestions.get(i).getReplacement()).matches()) continue;
            Matcher matcher = PARTICULA_FINAL.matcher(suggestions.get(i).getReplacement());
            if (matcher.matches()) {
                newSuggestions.add(0, suggestions.get(i));
                continue;
            }
            newSuggestions.add(suggestions.get(i));
        }
        return newSuggestions;
    }

    protected List<SuggestedReplacement> getAdditionalTopSuggestions(List<SuggestedReplacement> suggestions, String word) throws IOException {
        List<String> suggestionsList = suggestions.stream().map(SuggestedReplacement::getReplacement).collect(Collectors.toList());
        return SuggestedReplacement.convert(this.getAdditionalTopSuggestionsString(suggestionsList, word));
    }

    private List<String> getAdditionalTopSuggestionsString(List<String> suggestions, String word) throws IOException {
        String suggestion = "";
        if (!(suggestion = this.findSuggestion(suggestion, word, SPLIT_SUGGESTIONS, ANY_TAG, 1, " ", true)).isEmpty()) {
            return Collections.singletonList(suggestion);
        }
        return Collections.emptyList();
    }

    private String findSuggestion(String suggestion, String word, Pattern wordPattern, Pattern postagPattern, int suggestionPosition, String separator, boolean recursive) throws IOException {
        if (!suggestion.isEmpty()) {
            return suggestion;
        }
        Matcher matcher = wordPattern.matcher(word);
        if (matcher.matches()) {
            List moresugg;
            String newSuggestion = matcher.group(suggestionPosition);
            AnalyzedTokenReadings newatr = tagger.tag(Arrays.asList(newSuggestion)).get(0);
            if ((!newatr.hasPosTag("VMIP1S0B") || newSuggestion.equals("fer")) && this.matchPostagRegexp(newatr, postagPattern)) {
                return matcher.group(1) + separator + matcher.group(2);
            }
            if (recursive && (moresugg = this.speller1.getSuggestions(newSuggestion)).size() > 0) {
                String newWord = suggestionPosition == 1 ? (String)moresugg.get(0) + matcher.group(2) : matcher.group(1) + ((String)moresugg.get(0)).toLowerCase();
                return this.findSuggestion(suggestion, newWord, wordPattern, postagPattern, suggestionPosition, separator, false);
            }
        }
        return "";
    }

    private boolean matchPostagRegexp(AnalyzedTokenReadings aToken, Pattern pattern) {
        for (AnalyzedToken analyzedToken : aToken) {
            Matcher m;
            String posTag = analyzedToken.getPOSTag();
            if (posTag == null) {
                posTag = "UNKNOWN";
            }
            if (!(m = pattern.matcher(posTag)).matches()) continue;
            return true;
        }
        return false;
    }
}

