/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.language.Contributor;
import org.languagetool.rules.CommaWhitespaceRule;
import org.languagetool.rules.DoublePunctuationRule;
import org.languagetool.rules.GenericUnpairedBracketsRule;
import org.languagetool.rules.MultipleWhitespaceRule;
import org.languagetool.rules.Rule;
import org.languagetool.rules.UppercaseSentenceStartRule;
import org.languagetool.rules.WordRepeatRule;
import org.languagetool.rules.es.MorfologikSpanishSpellerRule;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.synthesis.es.SpanishSynthesizer;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tagging.disambiguation.es.SpanishHybridDisambiguator;
import org.languagetool.tagging.es.SpanishTagger;
import org.languagetool.tokenizers.SRXSentenceTokenizer;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tokenizers.Tokenizer;
import org.languagetool.tokenizers.es.SpanishWordTokenizer;

public class Spanish
extends Language {
    private SentenceTokenizer sentenceTokenizer;
    private Tokenizer wordTokenizer;
    private Synthesizer synthesizer;
    private Tagger tagger;
    private Disambiguator disambiguator;
    private String name = "Spanish";

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getShortName() {
        return "es";
    }

    public String[] getCountries() {
        return new String[]{"ES", "", "MX", "GT", "CR", "PA", "DO", "VE", "PE", "AR", "EC", "CL", "UY", "PY", "BO", "SV", "HN", "NI", "PR", "US", "CU"};
    }

    public String[] getUnpairedRuleStartSymbols() {
        return new String[]{"[", "(", "{", "\u201c", "\u00ab", "\u00bb", "\u00bf", "\u00a1"};
    }

    public String[] getUnpairedRuleEndSymbols() {
        return new String[]{"]", ")", "}", "\u201d", "\u00bb", "\u00ab", "?", "!"};
    }

    public Tagger getTagger() {
        if (this.tagger == null) {
            this.tagger = new SpanishTagger();
        }
        return this.tagger;
    }

    public Disambiguator getDisambiguator() {
        if (this.disambiguator == null) {
            this.disambiguator = new SpanishHybridDisambiguator();
        }
        return this.disambiguator;
    }

    public Tokenizer getWordTokenizer() {
        if (this.wordTokenizer == null) {
            this.wordTokenizer = new SpanishWordTokenizer();
        }
        return this.wordTokenizer;
    }

    public Synthesizer getSynthesizer() {
        if (this.synthesizer == null) {
            this.synthesizer = new SpanishSynthesizer();
        }
        return this.synthesizer;
    }

    public SentenceTokenizer getSentenceTokenizer() {
        if (this.sentenceTokenizer == null) {
            this.sentenceTokenizer = new SRXSentenceTokenizer((Language)this);
        }
        return this.sentenceTokenizer;
    }

    public Contributor[] getMaintainers() {
        Contributor contributor = new Contributor("Juan Martorell");
        contributor.setUrl("http://languagetool-es.blogspot.com/");
        return new Contributor[]{contributor};
    }

    public List<Rule> getRelevantRules(ResourceBundle messages) throws IOException {
        return Arrays.asList(new Rule[]{new CommaWhitespaceRule(messages), new DoublePunctuationRule(messages), new GenericUnpairedBracketsRule(messages, (Language)this), new MorfologikSpanishSpellerRule(messages, this), new UppercaseSentenceStartRule(messages, (Language)this), new WordRepeatRule(messages, (Language)this), new MultipleWhitespaceRule(messages, (Language)this)});
    }
}

