/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.es;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.TreeSet;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.rules.Category;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.es.SpanishRule;
import org.languagetool.tools.StringTools;

public class ElwithFemRule
extends SpanishRule {
    private static final String FILENAME_EL = "/es/el.txt";
    private final TreeSet<String> requiresEl;

    public ElwithFemRule(ResourceBundle messages) throws IOException {
        if (messages != null) {
            super.setCategory(new Category(messages.getString("category_misc")));
        }
        this.requiresEl = this.loadWords(JLanguageTool.getDataBroker().getFromRulesDirAsStream(FILENAME_EL));
    }

    public String getId() {
        return "EL_WITH_FEM";
    }

    public String getDescription() {
        return "Uso de 'el' con sustantivos femeninos que comienzan por a- o ha- t\u00f3nicas";
    }

    public RuleMatch[] match(AnalyzedSentence text) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = text.getTokensWithoutWhitespace();
        String prevToken = "";
        int prevPos = 0;
        for (int i = 1; i < tokens.length; ++i) {
            String token = tokens[i].getToken();
            boolean doesRequireEl = false;
            if (StringTools.isEmpty((String)(token = token.replaceAll("[^a-z\u00e1\u00e9\u00ed\u00f3\u00fa\u00f1\u00fcA-Z\u00c1\u00c9\u00cd\u00d3\u00da\u00d1\u00dc0-9\\.']", "")))) continue;
            if (this.requiresEl.contains(token.toLowerCase()) || this.requiresEl.contains(token)) {
                doesRequireEl = true;
            }
            if (prevToken.equals("La") && token.equals("Haya")) {
                doesRequireEl = false;
            }
            String msg = null;
            String replacement = null;
            if (prevToken.equalsIgnoreCase("la") && doesRequireEl) {
                replacement = "el";
                if (prevToken.equals("La")) {
                    replacement = "El";
                }
            } else if (prevToken.equalsIgnoreCase("una") && doesRequireEl) {
                replacement = "un";
                if (prevToken.equals("Una")) {
                    replacement = "Un";
                }
            } else if (prevToken.equalsIgnoreCase("alguna") && doesRequireEl) {
                replacement = "alg\u00fan";
                if (prevToken.equals("Alguna")) {
                    replacement = "Alg\u00fan";
                }
            } else if (prevToken.equalsIgnoreCase("ninguna") && doesRequireEl) {
                replacement = "ning\u00fan";
                if (prevToken.equals("Ninguna")) {
                    replacement = "Ning\u00fan";
                }
            }
            msg = "Use <suggestion>" + replacement + "</suggestion> en lugar de '" + prevToken + "' si la siguiente " + "palabra comienza por 'a' o 'ha' t\u00f3nicas, por ejemplo 'el hampa', " + "'un agua'";
            if (replacement != null) {
                RuleMatch ruleMatch = new RuleMatch((Rule)this, prevPos, prevPos + prevToken.length(), msg, "Art\u00edculo incorrecto");
                ruleMatches.add(ruleMatch);
            }
            if (tokens[i].hasPosTag("DA0FS0") || tokens[i].hasPosTag("DI0FS0")) {
                prevToken = token;
                prevPos = tokens[i].getStartPos();
                continue;
            }
            prevToken = "";
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TreeSet<String> loadWords(InputStream file) throws IOException {
        TreeSet<String> set = new TreeSet<String>();
        try (BufferedReader br = null;){
            String line;
            br = new BufferedReader(new InputStreamReader(file, "utf-8"));
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).length() < 1 || line.charAt(0) == '#') continue;
                if (line.charAt(0) == '*') {
                    set.add(line.substring(1));
                    continue;
                }
                set.add(line.toLowerCase());
            }
        }
        return set;
    }

    public void reset() {
    }
}

