/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.LanguageMaintainedState;
import org.languagetool.language.Contributor;
import org.languagetool.language.Contributors;
import org.languagetool.rules.CommaWhitespaceRule;
import org.languagetool.rules.DoublePunctuationRule;
import org.languagetool.rules.GenericUnpairedBracketsRule;
import org.languagetool.rules.MultipleWhitespaceRule;
import org.languagetool.rules.Rule;
import org.languagetool.rules.SentenceWhitespaceRule;
import org.languagetool.rules.UppercaseSentenceStartRule;
import org.languagetool.rules.WordRepeatRule;
import org.languagetool.rules.spelling.hunspell.HunspellNoSuggestionRule;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tagging.disambiguation.rules.XmlRuleDisambiguator;
import org.languagetool.tagging.eo.EsperantoTagger;
import org.languagetool.tokenizers.SRXSentenceTokenizer;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tokenizers.Tokenizer;
import org.languagetool.tokenizers.eo.EsperantoWordTokenizer;

public class Esperanto
extends Language {
    private SentenceTokenizer sentenceTokenizer;
    private Tokenizer wordTokenizer;
    private Disambiguator disambiguator;

    public SentenceTokenizer getSentenceTokenizer() {
        if (this.sentenceTokenizer == null) {
            this.sentenceTokenizer = new SRXSentenceTokenizer((Language)this);
        }
        return this.sentenceTokenizer;
    }

    public Tokenizer getWordTokenizer() {
        if (this.wordTokenizer == null) {
            this.wordTokenizer = new EsperantoWordTokenizer();
        }
        return this.wordTokenizer;
    }

    public String getName() {
        return "Esperanto";
    }

    public String getShortName() {
        return "eo";
    }

    public String getShortCode() {
        return "eo";
    }

    public String[] getCountries() {
        return new String[0];
    }

    public Tagger getTagger() {
        return new EsperantoTagger();
    }

    public Disambiguator getDisambiguator() {
        if (this.disambiguator == null) {
            this.disambiguator = new XmlRuleDisambiguator((Language)new Esperanto());
        }
        return this.disambiguator;
    }

    public Contributor[] getMaintainers() {
        return new Contributor[]{Contributors.DOMINIQUE_PELLE};
    }

    public List<Rule> getRelevantRules(ResourceBundle messages) {
        return Arrays.asList(new CommaWhitespaceRule(messages), new DoublePunctuationRule(messages), new GenericUnpairedBracketsRule(messages), new HunspellNoSuggestionRule(messages, (Language)this), new UppercaseSentenceStartRule(messages, (Language)this), new WordRepeatRule(messages, (Language)this), new MultipleWhitespaceRule(messages, (Language)this), new SentenceWhitespaceRule(messages));
    }

    public LanguageMaintainedState getMaintainedState() {
        return LanguageMaintainedState.ActivelyMaintained;
    }
}

