/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.Example;
import org.languagetool.rules.WordRepeatBeginningRule;

public class EnglishWordRepeatBeginningRule
extends WordRepeatBeginningRule {
    private static final Set<String> ADVERBS = new HashSet<String>();

    public EnglishWordRepeatBeginningRule(ResourceBundle messages, Language language) {
        super(messages, language);
        this.addExamplePair(Example.wrong((String)"Moreover, the street is almost entirely residential. <marker>Moreover</marker>, it was named after a poet."), Example.fixed((String)"Moreover, the street is almost entirely residential. <marker>It</marker> was named after a poet."));
    }

    public String getId() {
        return "ENGLISH_WORD_REPEAT_BEGINNING_RULE";
    }

    public boolean isException(String token) {
        return super.isException(token) || token.equals("The") || token.equals("A") || token.equals("An");
    }

    protected boolean isAdverb(AnalyzedTokenReadings token) {
        return ADVERBS.contains(token.getToken());
    }

    protected List<String> getSuggestions(AnalyzedTokenReadings token) {
        if (token.hasPosTag("PRP")) {
            String tok = token.getToken();
            String adaptedToken = tok.equals("I") ? tok : tok.toLowerCase();
            return Arrays.asList("Furthermore, " + adaptedToken, "Likewise, " + adaptedToken, "Not only that, but " + adaptedToken);
        }
        return Collections.emptyList();
    }

    static {
        ADVERBS.add("Additionally");
        ADVERBS.add("Besides");
        ADVERBS.add("Furthermore");
        ADVERBS.add("Moreover");
    }
}

