/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.Language;
import org.languagetool.LanguageMaintainedState;
import org.languagetool.UserConfig;
import org.languagetool.chunking.Chunker;
import org.languagetool.chunking.EnglishChunker;
import org.languagetool.language.AmericanEnglish;
import org.languagetool.language.Contributor;
import org.languagetool.language.Contributors;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.languagemodel.LuceneLanguageModel;
import org.languagetool.rules.CommaWhitespaceRule;
import org.languagetool.rules.DoublePunctuationRule;
import org.languagetool.rules.EmptyLineRule;
import org.languagetool.rules.Example;
import org.languagetool.rules.LongParagraphRule;
import org.languagetool.rules.LongSentenceRule;
import org.languagetool.rules.MultipleWhitespaceRule;
import org.languagetool.rules.ParagraphRepeatBeginningRule;
import org.languagetool.rules.PunctuationMarkAtParagraphEnd;
import org.languagetool.rules.ReadabilityRule;
import org.languagetool.rules.Rule;
import org.languagetool.rules.SentenceWhitespaceRule;
import org.languagetool.rules.UppercaseSentenceStartRule;
import org.languagetool.rules.WhiteSpaceAtBeginOfParagraph;
import org.languagetool.rules.WhiteSpaceBeforeParagraphEnd;
import org.languagetool.rules.en.AvsAnRule;
import org.languagetool.rules.en.CompoundRule;
import org.languagetool.rules.en.ContractionSpellingRule;
import org.languagetool.rules.en.EnglishConfusionProbabilityRule;
import org.languagetool.rules.en.EnglishDashRule;
import org.languagetool.rules.en.EnglishForGermansFalseFriendRule;
import org.languagetool.rules.en.EnglishNgramProbabilityRule;
import org.languagetool.rules.en.EnglishUnpairedBracketsRule;
import org.languagetool.rules.en.EnglishWordRepeatBeginningRule;
import org.languagetool.rules.en.EnglishWordRepeatRule;
import org.languagetool.rules.en.EnglishWrongWordInContextRule;
import org.languagetool.rules.en.WordCoherencyRule;
import org.languagetool.rules.neuralnetwork.NeuralNetworkRuleCreator;
import org.languagetool.rules.neuralnetwork.Word2VecModel;
import org.languagetool.rules.patterns.PatternRuleLoader;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.synthesis.en.EnglishSynthesizer;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tagging.disambiguation.rules.XmlRuleDisambiguator;
import org.languagetool.tagging.en.EnglishTagger;
import org.languagetool.tokenizers.SRXSentenceTokenizer;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tokenizers.WordTokenizer;
import org.languagetool.tokenizers.en.EnglishWordTokenizer;

public class English
extends Language
implements AutoCloseable {
    private static final LoadingCache<String, List<Rule>> cache = CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, List<Rule>>(){

        public List<Rule> load(@NotNull String path) throws IOException {
            ArrayList<Rule> rules = new ArrayList<Rule>();
            PatternRuleLoader loader = new PatternRuleLoader();
            try (InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(path);){
                rules.addAll(loader.getRules(is, path));
            }
            return rules;
        }
    });
    private static final Language AMERICAN_ENGLISH = new AmericanEnglish();
    private Tagger tagger;
    private Chunker chunker;
    private SentenceTokenizer sentenceTokenizer;
    private Synthesizer synthesizer;
    private Disambiguator disambiguator;
    private WordTokenizer wordTokenizer;
    private LuceneLanguageModel languageModel;

    @Deprecated
    public English() {
    }

    public Language getDefaultLanguageVariant() {
        return AMERICAN_ENGLISH;
    }

    public SentenceTokenizer getSentenceTokenizer() {
        if (this.sentenceTokenizer == null) {
            this.sentenceTokenizer = new SRXSentenceTokenizer((Language)this);
        }
        return this.sentenceTokenizer;
    }

    public String getName() {
        return "English";
    }

    public String getShortCode() {
        return "en";
    }

    public String[] getCountries() {
        return new String[0];
    }

    public Tagger getTagger() {
        if (this.tagger == null) {
            this.tagger = new EnglishTagger();
        }
        return this.tagger;
    }

    public Chunker getChunker() {
        if (this.chunker == null) {
            this.chunker = new EnglishChunker();
        }
        return this.chunker;
    }

    public Synthesizer getSynthesizer() {
        if (this.synthesizer == null) {
            this.synthesizer = new EnglishSynthesizer();
        }
        return this.synthesizer;
    }

    public Disambiguator getDisambiguator() {
        if (this.disambiguator == null) {
            this.disambiguator = new XmlRuleDisambiguator((Language)new English());
        }
        return this.disambiguator;
    }

    public WordTokenizer getWordTokenizer() {
        if (this.wordTokenizer == null) {
            this.wordTokenizer = new EnglishWordTokenizer();
        }
        return this.wordTokenizer;
    }

    public synchronized LanguageModel getLanguageModel(File indexDir) throws IOException {
        if (this.languageModel == null) {
            this.languageModel = new LuceneLanguageModel(new File(indexDir, this.getShortCode()));
        }
        return this.languageModel;
    }

    public synchronized Word2VecModel getWord2VecModel(File indexDir) throws IOException {
        return new Word2VecModel(indexDir + File.separator + this.getShortCode());
    }

    public Contributor[] getMaintainers() {
        return new Contributor[]{new Contributor("Mike Unwalla"), Contributors.MARCIN_MILKOWSKI, Contributors.DANIEL_NABER};
    }

    public LanguageMaintainedState getMaintainedState() {
        return LanguageMaintainedState.ActivelyMaintained;
    }

    public List<Rule> getRelevantRules(ResourceBundle messages, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
        ArrayList<Rule> allRules = new ArrayList<Rule>();
        if (motherTongue != null && "de".equals(motherTongue.getShortCode())) {
            allRules.addAll((Collection)cache.getUnchecked((Object)"/org/languagetool/rules/en/grammar-l2-de.xml"));
        }
        allRules.addAll(Arrays.asList(new Rule[]{new CommaWhitespaceRule(messages, Example.wrong((String)"We had coffee<marker> ,</marker> cheese and crackers and grapes."), Example.fixed((String)"We had coffee<marker>,</marker> cheese and crackers and grapes.")), new DoublePunctuationRule(messages), new UppercaseSentenceStartRule(messages, (Language)this, Example.wrong((String)"This house is old. <marker>it</marker> was built in 1950."), Example.fixed((String)"This house is old. <marker>It</marker> was built in 1950.")), new MultipleWhitespaceRule(messages, (Language)this), new SentenceWhitespaceRule(messages), new WhiteSpaceBeforeParagraphEnd(messages, (Language)this), new WhiteSpaceAtBeginOfParagraph(messages), new EmptyLineRule(messages, (Language)this), new LongSentenceRule(messages, userConfig), new LongParagraphRule(messages, (Language)this, userConfig), new ParagraphRepeatBeginningRule(messages, (Language)this), new PunctuationMarkAtParagraphEnd(messages, (Language)this), new EnglishUnpairedBracketsRule(messages, this), new EnglishWordRepeatRule(messages, this), new AvsAnRule(messages), new EnglishWordRepeatBeginningRule(messages, this), new CompoundRule(messages), new ContractionSpellingRule(messages), new EnglishWrongWordInContextRule(messages), new EnglishDashRule(), new WordCoherencyRule(messages), new ReadabilityRule(messages, (Language)this, userConfig, false), new ReadabilityRule(messages, (Language)this, userConfig, true)}));
        return allRules;
    }

    public List<Rule> getRelevantLanguageModelRules(ResourceBundle messages, LanguageModel languageModel) throws IOException {
        return Arrays.asList(new Rule[]{new EnglishConfusionProbabilityRule(messages, languageModel, this), new EnglishNgramProbabilityRule(messages, languageModel, this)});
    }

    public List<Rule> getRelevantLanguageModelCapableRules(ResourceBundle messages, @Nullable LanguageModel languageModel, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
        if (languageModel != null && motherTongue != null && "de".equals(motherTongue.getShortCode())) {
            return Arrays.asList(new Rule[]{new EnglishForGermansFalseFriendRule(messages, languageModel, motherTongue, this)});
        }
        return Arrays.asList(new Rule[0]);
    }

    public List<Rule> getRelevantWord2VecModelRules(ResourceBundle messages, Word2VecModel word2vecModel) throws IOException {
        return NeuralNetworkRuleCreator.createRules((ResourceBundle)messages, (Language)this, (Word2VecModel)word2vecModel);
    }

    public boolean hasNGramFalseFriendRule(Language motherTongue) {
        return motherTongue != null && "de".equals(motherTongue.getShortCode());
    }

    @Override
    public void close() throws Exception {
        if (this.languageModel != null) {
            this.languageModel.close();
        }
    }

    public int getPriorityForId(String id) {
        switch (id) {
            case "MISSING_HYPHEN": {
                return 5;
            }
            case "DO_HE_VERB": {
                return 1;
            }
            case "TWO_CONNECTED_MODAL_VERBS": {
                return -5;
            }
            case "CONFUSION_RULE": {
                return -10;
            }
            case "TOO_LONG_SENTENCE": {
                return -997;
            }
            case "TOO_LONG_PARAGRAPH": {
                return -998;
            }
        }
        return super.getPriorityForId(id);
    }
}

