/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en;

import java.io.IOException;
import java.util.List;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.rules.AbstractDashRule;
import org.languagetool.rules.Example;
import org.languagetool.rules.patterns.PatternRule;

public class EnglishDashRule
extends AbstractDashRule {
    private static final List<PatternRule> dashRules = EnglishDashRule.loadCompoundFile((String)"/en/compounds.txt", (String)"A dash was used instead of a hyphen. Did you mean: ", (Language)Languages.getLanguageForShortCode((String)"en"));

    public EnglishDashRule() throws IOException {
        super(dashRules);
        this.addExamplePair(Example.wrong((String)"I'll buy a new <marker>T\u2014shirt</marker>."), Example.fixed((String)"I'll buy a new <marker>T-shirt</marker>."));
    }

    public String getId() {
        return "EN_DASH_RULE";
    }

    public String getDescription() {
        return "Checks if hyphenated words were spelled with dashes (e.g., 'T \u2014 shirt' instead 'T-shirt').";
    }
}

