/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.languagetool.rules.AbstractSimpleReplaceRule;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;

public class BritishReplaceRule
extends AbstractSimpleReplaceRule {
    public static final String BRITISH_SIMPLE_REPLACE_RULE = "EN_GB_SIMPLE_REPLACE";
    private static final Map<String, List<String>> wrongWords = BritishReplaceRule.load((String)"/en/en-GB/replace.txt");
    private static final Locale EN_GB_LOCALE = new Locale("en-GB");

    protected Map<String, List<String>> getWrongWords() {
        return wrongWords;
    }

    public BritishReplaceRule(ResourceBundle messages) throws IOException {
        super(messages);
        this.setLocQualityIssueType(ITSIssueType.LocaleViolation);
        this.addExamplePair(Example.wrong((String)"We can produce <marker>drapes</marker> of any size or shape from a choice of over 500 different fabrics."), Example.fixed((String)"We can produce <marker>curtains</marker> of any size or shape from a choice of over 500 different fabrics."));
    }

    public final String getId() {
        return BRITISH_SIMPLE_REPLACE_RULE;
    }

    public String getDescription() {
        return "American words easily confused in British English";
    }

    public String getShort() {
        return "American word";
    }

    public String getMessage(String tokenStr, List<String> replacements) {
        return tokenStr + " is a common American expression, in British English it is more common to use: " + String.join((CharSequence)", ", replacements) + ".";
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public Locale getLocale() {
        return EN_GB_LOCALE;
    }
}

