/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.chunking.Chunker;
import org.languagetool.chunking.EnglishChunker;
import org.languagetool.language.AmericanEnglish;
import org.languagetool.language.Contributor;
import org.languagetool.language.Contributors;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.languagemodel.LuceneLanguageModel;
import org.languagetool.rules.CommaWhitespaceRule;
import org.languagetool.rules.DoublePunctuationRule;
import org.languagetool.rules.LongSentenceRule;
import org.languagetool.rules.MultipleWhitespaceRule;
import org.languagetool.rules.Rule;
import org.languagetool.rules.SentenceWhitespaceRule;
import org.languagetool.rules.UppercaseSentenceStartRule;
import org.languagetool.rules.en.AvsAnRule;
import org.languagetool.rules.en.CompoundRule;
import org.languagetool.rules.en.ContractionSpellingRule;
import org.languagetool.rules.en.EnglishConfusionProbabilityRule;
import org.languagetool.rules.en.EnglishUnpairedBracketsRule;
import org.languagetool.rules.en.EnglishWordRepeatBeginningRule;
import org.languagetool.rules.en.EnglishWordRepeatRule;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.synthesis.en.EnglishSynthesizer;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tagging.disambiguation.rules.XmlRuleDisambiguator;
import org.languagetool.tagging.en.EnglishTagger;
import org.languagetool.tokenizers.SRXSentenceTokenizer;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tokenizers.WordTokenizer;
import org.languagetool.tokenizers.en.EnglishWordTokenizer;

public class English
extends Language
implements AutoCloseable {
    private static final Language AMERICAN_ENGLISH = new AmericanEnglish();
    private Tagger tagger;
    private Chunker chunker;
    private SentenceTokenizer sentenceTokenizer;
    private Synthesizer synthesizer;
    private Disambiguator disambiguator;
    private WordTokenizer wordTokenizer;
    private LuceneLanguageModel languageModel;
    private String name = "English";

    public Language getDefaultLanguageVariant() {
        return AMERICAN_ENGLISH;
    }

    public SentenceTokenizer getSentenceTokenizer() {
        if (this.sentenceTokenizer == null) {
            this.sentenceTokenizer = new SRXSentenceTokenizer((Language)this);
        }
        return this.sentenceTokenizer;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getShortName() {
        return "en";
    }

    public String[] getCountries() {
        return new String[0];
    }

    public Tagger getTagger() {
        if (this.tagger == null) {
            this.tagger = new EnglishTagger();
        }
        return this.tagger;
    }

    public Chunker getChunker() {
        if (this.chunker == null) {
            this.chunker = new EnglishChunker();
        }
        return this.chunker;
    }

    public Synthesizer getSynthesizer() {
        if (this.synthesizer == null) {
            this.synthesizer = new EnglishSynthesizer();
        }
        return this.synthesizer;
    }

    public Disambiguator getDisambiguator() {
        if (this.disambiguator == null) {
            this.disambiguator = new XmlRuleDisambiguator((Language)new English());
        }
        return this.disambiguator;
    }

    public WordTokenizer getWordTokenizer() {
        if (this.wordTokenizer == null) {
            this.wordTokenizer = new EnglishWordTokenizer();
        }
        return this.wordTokenizer;
    }

    public synchronized LanguageModel getLanguageModel(File indexDir) throws IOException {
        if (this.languageModel == null) {
            this.languageModel = new LuceneLanguageModel(indexDir);
        }
        return this.languageModel;
    }

    public Contributor[] getMaintainers() {
        return new Contributor[]{Contributors.MARCIN_MILKOWSKI, Contributors.DANIEL_NABER};
    }

    public List<Rule> getRelevantRules(ResourceBundle messages) throws IOException {
        return Arrays.asList(new Rule[]{new CommaWhitespaceRule(messages), new DoublePunctuationRule(messages), new UppercaseSentenceStartRule(messages, (Language)this), new MultipleWhitespaceRule(messages, (Language)this), new LongSentenceRule(messages), new SentenceWhitespaceRule(messages), new EnglishUnpairedBracketsRule(messages, this), new EnglishWordRepeatRule(messages, this), new AvsAnRule(messages), new EnglishWordRepeatBeginningRule(messages, this), new CompoundRule(messages), new ContractionSpellingRule(messages)});
    }

    public List<Rule> getRelevantLanguageModelRules(ResourceBundle messages, LanguageModel languageModel) throws IOException {
        return Arrays.asList(new Rule[]{new EnglishConfusionProbabilityRule(messages, languageModel, this)});
    }

    @Override
    public void close() throws Exception {
        if (this.languageModel != null) {
            this.languageModel.close();
        }
    }
}

