/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.util.ArrayList;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;

public class WiederVsWiderRule
extends Rule {
    public WiederVsWiderRule(ResourceBundle messages) {
        super.setCategory(Categories.TYPOS.getCategory(messages));
        this.addExamplePair(Example.wrong((String)"Das spiegelt die Situation in Deutschland <marker>wieder</marker>."), Example.fixed((String)"Das spiegelt die Situation in Deutschland <marker>wider</marker>."));
    }

    public String getId() {
        return "DE_WIEDER_VS_WIDER";
    }

    public String getDescription() {
        return "M\u00f6glicher Tippfehler 'spiegeln ... wieder (wider)'";
    }

    public int estimateContextForSureMatch() {
        return 0;
    }

    public RuleMatch[] match(AnalyzedSentence sentence) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
        boolean foundSpiegelt = false;
        boolean foundWieder = false;
        boolean foundWider = false;
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i].getToken();
            if (tokens[i].hasLemma("spiegeln")) {
                foundSpiegelt = true;
            } else if (token.equalsIgnoreCase("wieder") && foundSpiegelt) {
                foundWieder = true;
            } else if (token.equalsIgnoreCase("wider") && foundSpiegelt) {
                foundWider = true;
            }
            if (!foundSpiegelt || !foundWieder || foundWider || tokens.length > i + 2 && (tokens[i + 1].getToken().equals("wider") || tokens[i + 2].getToken().equals("wider"))) continue;
            String msg = "'wider' in 'widerspiegeln' wird mit 'i' statt mit 'ie' geschrieben, z.B. 'Das spiegelt die Situation gut wider.'";
            String shortMsg = "'wider' in 'widerspiegeln' wird mit 'i' geschrieben";
            int pos = tokens[i].getStartPos();
            RuleMatch ruleMatch = new RuleMatch((Rule)this, sentence, pos, pos + token.length(), msg, shortMsg);
            ruleMatch.setSuggestedReplacement("wider");
            ruleMatches.add(ruleMatch);
            foundSpiegelt = false;
            foundWieder = false;
            foundWider = false;
        }
        return this.toRuleMatchArray(ruleMatches);
    }
}

