/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.rules.Category;
import org.languagetool.rules.CategoryId;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.RuleOption;
import org.languagetool.rules.TextLevelRule;
import org.languagetool.tools.Tools;

public class StyleRepeatedVeryShortSentences
extends TextLevelRule {
    private static final int MIN_REPEATED = 3;
    private static final int MIN_WORDS = 4;
    private static final boolean EXCLUDE_DIRECT_SPEECH = true;
    private static final Pattern OPENING_QUOTES = Pattern.compile("[\"\u201c\u201e\u00bb\u00ab]");
    private static final Pattern ENDING_QUOTES = Pattern.compile("[\"\u201c\u201d\u00bb\u00ab]");
    private final Language lang;
    private int minWords = 4;
    private int minRepeated = 3;
    private boolean excludeDirectSpeech = true;

    public StyleRepeatedVeryShortSentences(ResourceBundle messages, Language lang, UserConfig userConfig) {
        super(messages);
        Object[] cf;
        super.setCategory(new Category(new CategoryId("CREATIVE_WRITING"), messages.getString("category_creative_writing"), Category.Location.INTERNAL, false));
        this.lang = lang;
        this.setDefaultOff();
        this.setLocQualityIssueType(ITSIssueType.Style);
        this.addExamplePair(Example.wrong((String)"Das Auto kam <marker>n\u00e4her.</marker> Der Hund <marker>schlief.</marker> Die Reifen <marker>quietschten.</marker>"), Example.fixed((String)"Das Auto kam n\u00e4her. Tief und fest schlief der Hund. Die Reifen quietschten."));
        if (userConfig != null && (cf = userConfig.getConfigValueByID(this.getId())) != null) {
            if (cf.length > 0 && cf[0] != null && cf[0] instanceof Integer) {
                this.minRepeated = (Integer)cf[0];
            }
            if (cf.length > 1 && cf[1] != null && cf[1] instanceof Integer) {
                this.minWords = (Integer)cf[1];
            }
            if (cf.length > 2 && cf[2] != null && cf[2] instanceof Boolean) {
                this.excludeDirectSpeech = (Boolean)cf[2];
            }
        }
    }

    public RuleMatch[] match(List<AnalyzedSentence> sentences) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        if (sentences.size() < this.minRepeated) {
            return this.toRuleMatchArray(ruleMatches);
        }
        int pos = 0;
        int nRepeated = 0;
        ArrayList<Integer> startPos = new ArrayList<Integer>();
        ArrayList<Integer> endPos = new ArrayList<Integer>();
        ArrayList<AnalyzedSentence> repeatedSentences = new ArrayList<AnalyzedSentence>();
        AnalyzedTokenReadings[] tokens = null;
        int n = -1;
        int nPara = -1;
        boolean beginnsWithDirectSpeech = false;
        boolean endsWithDirectSpeech = false;
        for (AnalyzedSentence sentence : sentences) {
            ++n;
            ++nPara;
            tokens = sentence.getTokensWithoutWhitespace();
            if (this.excludeDirectSpeech) {
                beginnsWithDirectSpeech = endsWithDirectSpeech;
                for (int i = 0; i < tokens.length; ++i) {
                    if (!beginnsWithDirectSpeech && OPENING_QUOTES.matcher(tokens[i].getToken()).matches() && i < tokens.length - 1 && !tokens[i + 1].isWhitespaceBefore()) {
                        beginnsWithDirectSpeech = true;
                        endsWithDirectSpeech = true;
                        continue;
                    }
                    if (!beginnsWithDirectSpeech || !ENDING_QUOTES.matcher(tokens[i].getToken()).matches() || i <= 1 || tokens[i].isWhitespaceBefore()) continue;
                    endsWithDirectSpeech = false;
                }
            }
            boolean paragraphEnd = Tools.isParagraphEnd(sentences, (int)n, (Language)this.lang);
            if (!(beginnsWithDirectSpeech || paragraphEnd && nPara <= 0 || tokens.length <= 3 || tokens.length > this.minWords + 2)) {
                repeatedSentences.add(sentence);
                startPos.add(tokens[tokens.length - 2].getStartPos() + pos);
                endPos.add(tokens[tokens.length - 1].getEndPos() + pos);
                ++nRepeated;
            } else {
                if (nRepeated >= this.minRepeated) {
                    for (int i = 0; i < repeatedSentences.size(); ++i) {
                        RuleMatch ruleMatch = new RuleMatch((Rule)this, (AnalyzedSentence)repeatedSentences.get(i), ((Integer)startPos.get(i)).intValue(), ((Integer)endPos.get(i)).intValue(), this.getDescription());
                        ruleMatches.add(ruleMatch);
                    }
                }
                repeatedSentences.clear();
                startPos.clear();
                endPos.clear();
                nRepeated = 0;
            }
            pos += sentence.getCorrectedTextLength();
            if (!paragraphEnd) continue;
            nPara = -1;
        }
        if (nRepeated >= this.minRepeated) {
            for (int i = 0; i < repeatedSentences.size(); ++i) {
                RuleMatch ruleMatch = new RuleMatch((Rule)this, (AnalyzedSentence)repeatedSentences.get(i), ((Integer)startPos.get(i)).intValue(), ((Integer)endPos.get(i)).intValue(), this.getDescription());
                ruleMatches.add(ruleMatch);
            }
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    public int minToCheckParagraph() {
        return this.minRepeated;
    }

    public String getId() {
        return "STYLE_REPEATED_SHORT_SENTENCES";
    }

    public String getDescription() {
        return "Stakkato-S\u00e4tze";
    }

    public RuleOption[] getRuleOptions() {
        RuleOption[] ruleOptions = new RuleOption[]{new RuleOption((Object)3, "Anzahl von kurzen S\u00e4tzen hintereinander", (Object)0, (Object)10), new RuleOption((Object)4, "Maximale L\u00e4nge eines kurzen Satzes", (Object)0, (Object)10), new RuleOption((Object)true, "Direkte Rede und Zitate ausschlie\u00dfen")};
        return ruleOptions;
    }
}

