/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.rules.AbstractStatisticSentenceStyleRule;

public class PassiveSentenceRule
extends AbstractStatisticSentenceStyleRule {
    private static final int DEFAULT_MIN_PERCENT = 8;
    String sentenceMessage = null;

    public PassiveSentenceRule(ResourceBundle messages, Language lang, UserConfig userConfig) {
        super(messages, lang, userConfig, 8);
    }

    protected AnalyzedTokenReadings conditionFulfilled(List<AnalyzedTokenReadings> sentence) {
        for (int i = 0; i < sentence.size(); ++i) {
            if (sentence.get(i).hasLemma("werden")) {
                AnalyzedTokenReadings token = sentence.get(i);
                ++i;
                while (i < sentence.size()) {
                    if (sentence.get(i).hasPosTagStartingWith("VER:PA2:")) {
                        return token;
                    }
                    if (this.isMark(sentence.get(i))) {
                        return null;
                    }
                    ++i;
                }
                continue;
            }
            if (!sentence.get(i).hasPosTagStartingWith("VER:PA2:")) continue;
            ++i;
            while (i < sentence.size()) {
                if (sentence.get(i).hasLemma("werden")) {
                    return sentence.get(i);
                }
                if (this.isMark(sentence.get(i))) {
                    return null;
                }
                ++i;
            }
        }
        return null;
    }

    protected boolean excludeDirectSpeech() {
        return true;
    }

    protected String getLimitMessage(int limit, double percent) {
        if (limit == 0) {
            return "Passivsatz: Aktiv formulierte S\u00e4tze sprechen im Regelfall den Leser st\u00e4rker an.";
        }
        return "Mehr als " + limit + "% Passivs\u00e4tze {" + (int)(percent + 0.5) + "%} gefunden. Aktiv formulierte S\u00e4tze sprechen im Regelfall den Leser st\u00e4rker an.";
    }

    public String getId() {
        return "PASSIVE_SENTENCE_DE";
    }

    public String getDescription() {
        return "Statistische Stilanalyse: Passivs\u00e4tze";
    }

    public String getConfigureText() {
        return "Anzeigen wenn mehr als ...% S\u00e4tze eines Kapitels Passivs\u00e4tze sind:";
    }
}

