/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import morfologik.speller.Speller;
import org.apache.commons.lang3.StringUtils;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.rules.AbstractStyleRepeatedWordRule;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.RuleOption;
import org.languagetool.rules.spelling.morfologik.MorfologikSpeller;
import org.languagetool.tools.StringTools;

public class GermanStyleRepeatedWordRule
extends AbstractStyleRepeatedWordRule {
    private static final String SYNONYMS_URL = "https://www.openthesaurus.de/synonyme/";
    private static final Pattern LETTERS = Pattern.compile("^[A-Za-z\u00c4\u00d6\u00dc\u00e4\u00f6\u00fc\u00df]+$");
    private static final int MAX_DISTANCE_OF_SENTENCES = 1;
    private static final boolean EXCLUDE_DIRECT_SPEECH = true;
    private static final boolean TEST_COMPOUND_WORDS = false;
    private Speller speller = null;
    private boolean testCompoundWords = false;

    public GermanStyleRepeatedWordRule(ResourceBundle messages, Language lang, UserConfig userConfig) {
        super(messages, lang, userConfig);
        Object[] cf;
        super.setCategory(Categories.STYLE.getCategory(messages));
        this.addExamplePair(Example.wrong((String)"Ich gehe zum Supermarkt, danach <marker>gehe</marker> ich nach Hause."), Example.fixed((String)"Ich gehe zum Supermarkt, danach nach Hause."));
        if (userConfig != null && (cf = userConfig.getConfigValueByID(this.getId())) != null && cf.length > 2) {
            this.testCompoundWords = (Boolean)cf[2];
        }
    }

    public String getId() {
        return "STYLE_REPEATED_WORD_RULE_DE";
    }

    public String getDescription() {
        return "Wiederholte Worte in aufeinanderfolgenden S\u00e4tzen";
    }

    protected String messageSameSentence() {
        return "M\u00f6gliches Stilproblem: Das Wort wird noch einmal im selben Satz verwendet.";
    }

    protected String messageSentenceBefore() {
        return "M\u00f6gliches Stilproblem: Das Wort wird bereits in einem vorhergehenden Satz verwendet.";
    }

    protected String messageSentenceAfter() {
        return "M\u00f6gliches Stilproblem: Das Wort wird auch in einem nachfolgenden Satz verwendet.";
    }

    public RuleOption[] getRuleOptions() {
        RuleOption[] ruleOptions = new RuleOption[]{new RuleOption((Object)1, this.messages.getString("guiStyleRepeatedWordText"), (Object)0, (Object)5), new RuleOption((Object)true, "Direkte Rede und Zitate ausschlie\u00dfen"), new RuleOption((Object)false, "Auch zusammengesetzte W\u00f6rter pr\u00fcfen")};
        return ruleOptions;
    }

    private boolean isCorrectSpell(String word) {
        word = StringTools.uppercaseFirstChar((String)word);
        if (this.speller == null) {
            this.speller = new Speller(MorfologikSpeller.getDictionaryWithCaching((String)"/de/hunspell/de_DE.dict"));
        }
        if (this.speller != null) {
            return !this.speller.isMisspelled(word);
        }
        if (this.linguServices != null) {
            return this.linguServices.isCorrectSpell(word, this.lang);
        }
        throw new IllegalStateException("LinguServices or Speller must be not null to check spelling in CompoundInfinitivRule");
    }

    private static boolean isUnknownWord(AnalyzedTokenReadings token) {
        return token.isPosTagUnknown() && token.getToken().length() > 2 && LETTERS.matcher(token.getToken()).matches();
    }

    protected boolean isTokenToCheck(AnalyzedTokenReadings token) {
        return (token.matchesPosTagRegex("(SUB|EIG|VER|ADJ):.*") && !token.matchesPosTagRegex("(PRO|A(RT|DV)|VER:(AUX|MOD)):.*") || GermanStyleRepeatedWordRule.isUnknownWord(token)) && !StringUtils.equalsAny((CharSequence)token.getToken(), (CharSequence[])new CharSequence[]{"sicher", "weit", "Sie", "Ich", "Euch", "Eure", "Der", "all"});
    }

    protected boolean isTokenPair(AnalyzedTokenReadings[] tokens, int n, boolean before) {
        return before ? n > 2 && n < tokens.length && tokens[n - 2].hasPosTagStartingWith("SUB") && tokens[n - 1].hasPosTagStartingWith("PRP") && tokens[n].hasPosTagStartingWith("SUB") || tokens[n - 2].getToken().equals("hart") && tokens[n - 1].getToken().equals("auf") && tokens[n].getToken().equals("hart") || tokens[n - 2].getToken().equals("dicht") && tokens[n - 1].getToken().equals("an") && tokens[n].getToken().equals("dicht") || tokens[n - 2].getToken().equals("fressen") && tokens[n - 1].getToken().equals("und") && tokens[n].getToken().equals("gefressen") : n > 0 && n < tokens.length - 2 && tokens[n].hasPosTagStartingWith("SUB") && tokens[n + 1].hasPosTagStartingWith("PRP") && tokens[n + 2].hasPosTagStartingWith("SUB") || tokens[n].getToken().equals("hart") && tokens[n + 1].getToken().equals("auf") && tokens[n + 2].getToken().equals("hart") || tokens[n].getToken().equals("dicht") && tokens[n + 1].getToken().equals("an") && tokens[n + 2].getToken().equals("dicht") || tokens[n].getToken().equals("fressen") && tokens[n + 1].getToken().equals("und") && tokens[n + 2].getToken().equals("gefressen");
    }

    private boolean isSecondPartofWord(String testTokenText, String tokenText) {
        if (testTokenText.length() - tokenText.length() < 3) {
            return false;
        }
        String lowerTokenText = StringTools.lowercaseFirstChar((String)tokenText);
        if (lowerTokenText.equals("frei") || lowerTokenText.equals("alten") && testTokenText.endsWith("halten")) {
            return false;
        }
        if (StringTools.lowercaseFirstChar((String)testTokenText).startsWith(lowerTokenText)) {
            String word = testTokenText.substring(tokenText.length());
            if (this.isCorrectSpell(word)) {
                return true;
            }
            return word.startsWith("s") && this.isCorrectSpell(word = word.substring(1));
        }
        if (testTokenText.endsWith(lowerTokenText)) {
            String word = testTokenText.substring(0, testTokenText.length() - tokenText.length());
            if (this.isCorrectSpell(word)) {
                return true;
            }
            return word.endsWith("s") && this.isCorrectSpell(word = word.substring(word.length() - 1));
        }
        return false;
    }

    protected boolean isPartOfWord(String testTokenText, String tokenText) {
        if (!this.testCompoundWords || testTokenText.length() < 3 || tokenText.length() < 3) {
            return false;
        }
        if (testTokenText.length() > tokenText.length()) {
            return this.isSecondPartofWord(testTokenText, tokenText);
        }
        return this.isSecondPartofWord(tokenText, testTokenText);
    }

    protected boolean isExceptionPair(AnalyzedTokenReadings token1, AnalyzedTokenReadings token2) {
        if (token1.hasLemma("nah") && token1.hasLemma("n\u00e4chst") && !token2.hasLemma("n\u00e4chst") || token2.hasLemma("nah") && token2.hasLemma("n\u00e4chst") && !token1.hasLemma("n\u00e4chst")) {
            return true;
        }
        return token1.hasLemma("gut") && (token1.getToken().startsWith("gut") && !token2.getToken().startsWith("gut") || token2.getToken().startsWith("gut") && !token1.getToken().startsWith("gut"));
    }

    protected URL setURL(AnalyzedTokenReadings token) throws MalformedURLException {
        if (token != null) {
            List readings = token.getReadings();
            ArrayList<String> lemmas = new ArrayList<String>();
            for (AnalyzedToken reading : readings) {
                String lemma = reading.getLemma();
                if (lemma == null) continue;
                lemmas.add(lemma);
            }
            if (lemmas.size() == 1) {
                return new URL(SYNONYMS_URL + (String)lemmas.get(0));
            }
            return new URL(SYNONYMS_URL + token.getToken());
        }
        return null;
    }
}

