/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.rules.AbstractStatisticSentenceStyleRule;

public class ConjunctionAtBeginOfSentenceRule
extends AbstractStatisticSentenceStyleRule {
    private static final int DEFAULT_MIN_PERCENT = 10;
    String sentenceMessage = null;

    public ConjunctionAtBeginOfSentenceRule(ResourceBundle messages, Language lang, UserConfig userConfig) {
        super(messages, lang, userConfig, 10);
    }

    private static boolean isConjunction(AnalyzedTokenReadings token) {
        return token.hasPosTagStartingWith("KON");
    }

    private static boolean isComma(AnalyzedTokenReadings token) {
        return ",".equals(token.getToken());
    }

    protected AnalyzedTokenReadings conditionFulfilled(List<AnalyzedTokenReadings> sentence) {
        int i;
        if (sentence.size() < 3) {
            return null;
        }
        AnalyzedTokenReadings token = null;
        int num = 0;
        if (this.isOpeningQuote(sentence.get(0))) {
            ++num;
        }
        if (ConjunctionAtBeginOfSentenceRule.isConjunction(sentence.get(num))) {
            token = sentence.get(num);
        }
        if (token == null || token.getToken().equals("Wie") || token.getToken().equals("Seit") || token.getToken().equals("Allerdings") || token.getToken().equals("Aber") && sentence.get(num + 1).getToken().equals("auch")) {
            return null;
        }
        if (token.getToken().equals("Um")) {
            for (int i2 = 1; i2 < sentence.size(); ++i2) {
                if (!ConjunctionAtBeginOfSentenceRule.isComma(sentence.get(i2)) && !sentence.get(i2).getToken().equals("herum")) continue;
                return null;
            }
            return token;
        }
        if (!token.hasPosTagStartingWith("KON:UNT") || token.getToken().equals("Sondern") || token.getToken().equals("Auch") && sentence.get(num + 1).getToken().equals("wenn")) {
            if (token.getToken().equals("Entweder")) {
                for (i = 1; i < sentence.size(); ++i) {
                    if (!sentence.get(i).getToken().equals("oder")) continue;
                    return null;
                }
            } else if (token.getToken().equals("Sowohl")) {
                for (i = 1; i < sentence.size() - 1; ++i) {
                    if (!sentence.get(i).getToken().equals("als") || !sentence.get(i + 1).getToken().equals("auch")) continue;
                    return null;
                }
            } else if (token.getToken().equals("Weder")) {
                for (i = 1; i < sentence.size(); ++i) {
                    if (!sentence.get(i).getToken().equals("noch")) continue;
                    return null;
                }
            } else {
                if (sentence.get(sentence.size() - 1).getToken().equals("?")) {
                    return null;
                }
                return token;
            }
        }
        for (i = 2; i < sentence.size(); ++i) {
            if (!ConjunctionAtBeginOfSentenceRule.isComma(sentence.get(i))) continue;
            return null;
        }
        return token;
    }

    protected boolean excludeDirectSpeech() {
        return true;
    }

    protected String getLimitMessage(int limit, double percent) {
        if (limit == 0) {
            return "Eine Konjunktion sollte nur in Ausnahmef\u00e4llen am Satzanfang verwendet werden. Formulieren Sie den Satz um, falls m\u00f6glich.";
        }
        return "Mehr als " + limit + "% S\u00e4tze beginnen mit einer Konjunktion {" + (int)(percent + 0.5) + "%} gefunden. Formulieren Sie den Satz um, falls m\u00f6glich.";
    }

    public String getId() {
        return "SENTENCE_BEGINNING_WITH_CONJUNCTION_DE";
    }

    public String getDescription() {
        return "Statistische Stilanalyse: S\u00e4tze beginnend mit Konjunktion";
    }

    public String getConfigureText() {
        return "Anzeigen wenn mehr als ...% S\u00e4tze eines Kapitels mit einer Konjunktion beginnen:";
    }
}

