/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.Language;
import org.languagetool.LanguageMaintainedState;
import org.languagetool.LanguageWithModel;
import org.languagetool.Tag;
import org.languagetool.UserConfig;
import org.languagetool.chunking.Chunker;
import org.languagetool.chunking.GermanChunker;
import org.languagetool.language.Contributor;
import org.languagetool.language.Contributors;
import org.languagetool.language.GermanyGerman;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.markup.AnnotatedText;
import org.languagetool.rules.EmptyLineRule;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.LongParagraphRule;
import org.languagetool.rules.MultipleWhitespaceRule;
import org.languagetool.rules.PunctuationMarkAtParagraphEnd;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.UppercaseSentenceStartRule;
import org.languagetool.rules.WhiteSpaceAtBeginOfParagraph;
import org.languagetool.rules.WhiteSpaceBeforeParagraphEnd;
import org.languagetool.rules.de.AgreementRule;
import org.languagetool.rules.de.AgreementRule2;
import org.languagetool.rules.de.CaseRule;
import org.languagetool.rules.de.CompoundCoherencyRule;
import org.languagetool.rules.de.CompoundInfinitivRule;
import org.languagetool.rules.de.ConjunctionAtBeginOfSentenceRule;
import org.languagetool.rules.de.DashRule;
import org.languagetool.rules.de.DuUpperLowerCaseRule;
import org.languagetool.rules.de.GermanCommaWhitespaceRule;
import org.languagetool.rules.de.GermanConfusionProbabilityRule;
import org.languagetool.rules.de.GermanDoublePunctuationRule;
import org.languagetool.rules.de.GermanFillerWordsRule;
import org.languagetool.rules.de.GermanMultitokenSpeller;
import org.languagetool.rules.de.GermanParagraphRepeatBeginningRule;
import org.languagetool.rules.de.GermanReadabilityRule;
import org.languagetool.rules.de.GermanRepeatedWordsRule;
import org.languagetool.rules.de.GermanSpellerRule;
import org.languagetool.rules.de.GermanStyleRepeatedWordRule;
import org.languagetool.rules.de.GermanUnpairedBracketsRule;
import org.languagetool.rules.de.GermanUnpairedQuotesRule;
import org.languagetool.rules.de.GermanWordRepeatBeginningRule;
import org.languagetool.rules.de.GermanWordRepeatRule;
import org.languagetool.rules.de.GermanWrongWordInContextRule;
import org.languagetool.rules.de.LongSentenceRule;
import org.languagetool.rules.de.MissingCommaRelativeClauseRule;
import org.languagetool.rules.de.MissingVerbRule;
import org.languagetool.rules.de.NonSignificantVerbsRule;
import org.languagetool.rules.de.OldSpellingRule;
import org.languagetool.rules.de.PassiveSentenceRule;
import org.languagetool.rules.de.ProhibitedCompoundRule;
import org.languagetool.rules.de.RedundantModalOrAuxiliaryVerb;
import org.languagetool.rules.de.SentenceWhitespaceRule;
import org.languagetool.rules.de.SentenceWithManRule;
import org.languagetool.rules.de.SentenceWithModalVerbRule;
import org.languagetool.rules.de.SimilarNameRule;
import org.languagetool.rules.de.SimpleReplaceRule;
import org.languagetool.rules.de.StyleRepeatedSentenceBeginning;
import org.languagetool.rules.de.StyleRepeatedVeryShortSentences;
import org.languagetool.rules.de.StyleTooOftenUsedAdjectiveRule;
import org.languagetool.rules.de.StyleTooOftenUsedNounRule;
import org.languagetool.rules.de.StyleTooOftenUsedVerbRule;
import org.languagetool.rules.de.SubjectVerbAgreementRule;
import org.languagetool.rules.de.UnitConversionRule;
import org.languagetool.rules.de.UnnecessaryPhraseRule;
import org.languagetool.rules.de.UpperCaseNgramRule;
import org.languagetool.rules.de.VerbAgreementRule;
import org.languagetool.rules.de.WiederVsWiderRule;
import org.languagetool.rules.de.WordCoherencyRule;
import org.languagetool.rules.spelling.SpellingCheckRule;
import org.languagetool.rules.spelling.multitoken.MultitokenSpeller;
import org.languagetool.synthesis.GermanSynthesizer;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.de.GermanTagger;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tagging.disambiguation.rules.de.GermanRuleDisambiguator;
import org.languagetool.tokenizers.CompoundWordTokenizer;
import org.languagetool.tokenizers.SRXSentenceTokenizer;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tokenizers.Tokenizer;
import org.languagetool.tokenizers.de.GermanCompoundTokenizer;
import org.languagetool.tokenizers.de.GermanWordTokenizer;
import org.languagetool.tools.Tools;

public class German
extends LanguageWithModel {
    private static final Pattern TYPOGRAPHY_PATTERN = Pattern.compile("\\b([a-zA-Z]\\.)([a-zA-Z]\\.)");
    private static final Pattern AI_DE_GGEC_MISSING_PUNCT = Pattern.compile("AI_DE_GGEC_MISSING_PUNCTUATION_\\d+_DASH_J(_|AE)HRIG|AI_DE_GGEC_REPLACEMENT_CONFUSION", 2);
    private static final String GERMAN_SHORT_CODE = "de";
    private static final Map<String, Integer> id2prio = new HashMap<String, Integer>();

    @Deprecated
    public German() {
    }

    public Language getDefaultLanguageVariant() {
        return GermanyGerman.getInstance();
    }

    public SpellingCheckRule createDefaultSpellingRule(ResourceBundle messages) throws IOException {
        return new GermanSpellerRule(messages, this);
    }

    @NotNull
    public GermanSpellerRule getDefaultSpellingRule() {
        return (GermanSpellerRule)Objects.requireNonNull(super.getDefaultSpellingRule());
    }

    public Disambiguator createDefaultDisambiguator() {
        return new GermanRuleDisambiguator(this.getDefaultLanguageVariant());
    }

    @Nullable
    public Chunker createDefaultPostDisambiguationChunker() {
        return new GermanChunker();
    }

    public String getName() {
        return "German";
    }

    public String getShortCode() {
        return GERMAN_SHORT_CODE;
    }

    public String[] getCountries() {
        return new String[]{"LU", "LI", "BE"};
    }

    @NotNull
    public Tagger createDefaultTagger() {
        return GermanTagger.INSTANCE;
    }

    @Nullable
    public Synthesizer createDefaultSynthesizer() {
        return GermanSynthesizer.INSTANCE;
    }

    public SentenceTokenizer createDefaultSentenceTokenizer() {
        return new SRXSentenceTokenizer((Language)this);
    }

    public Contributor[] getMaintainers() {
        return new Contributor[]{new Contributor("Jan Schreiber"), Contributors.DANIEL_NABER};
    }

    public List<Rule> getRelevantRules(ResourceBundle messages, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
        return Arrays.asList(new Rule[]{new GermanCommaWhitespaceRule(messages, Example.wrong((String)"Die Partei<marker> ,</marker> die die letzte Wahl gewann."), Example.fixed((String)"Die Partei<marker>,</marker> die die letzte Wahl gewann."), Tools.getUrl((String)"https://languagetool.org/insights/de/beitrag/grammatik-leerzeichen/#fehler-1-leerzeichen-vor-und-nach-satzzeichen")), new GermanUnpairedBracketsRule(messages, (Language)this), new GermanUnpairedQuotesRule(messages, (Language)this), new UppercaseSentenceStartRule(messages, (Language)this, Example.wrong((String)"Das Haus ist alt. <marker>es</marker> wurde 1950 gebaut."), Example.fixed((String)"Das Haus ist alt. <marker>Es</marker> wurde 1950 gebaut."), Tools.getUrl((String)"https://languagetool.org/insights/de/beitrag/gross-klein-schreibung-rechtschreibung/#1-satzanf%C3%A4nge-schreiben-wir-gro%C3%9F")), new MultipleWhitespaceRule(messages, (Language)this), new WhiteSpaceBeforeParagraphEnd(messages, (Language)this), new WhiteSpaceAtBeginOfParagraph(messages), new EmptyLineRule(messages, (Language)this), new LongParagraphRule(messages, (Language)this, userConfig), new PunctuationMarkAtParagraphEnd(messages, (Language)this), new SimpleReplaceRule(messages, (Language)this), new OldSpellingRule(messages, (Language)this), new SentenceWhitespaceRule(messages), new GermanDoublePunctuationRule(messages), new MissingVerbRule(messages, this), new GermanWordRepeatRule(messages, (Language)this), new GermanWordRepeatBeginningRule(messages, (Language)this), new GermanWrongWordInContextRule(messages, (Language)this), new AgreementRule(messages, this), new AgreementRule2(messages, (Language)this), new CaseRule(messages, this), new DashRule(messages), new VerbAgreementRule(messages, this), new SubjectVerbAgreementRule(messages, this), new WordCoherencyRule(messages), new SimilarNameRule(messages), new WiederVsWiderRule(messages), new GermanStyleRepeatedWordRule(messages, (Language)this, userConfig), new CompoundCoherencyRule(messages), new LongSentenceRule(messages, userConfig, 40), new GermanFillerWordsRule(messages, (Language)this, userConfig), new PassiveSentenceRule(messages, (Language)this, userConfig), new SentenceWithModalVerbRule(messages, (Language)this, userConfig), new SentenceWithManRule(messages, (Language)this, userConfig), new ConjunctionAtBeginOfSentenceRule(messages, (Language)this, userConfig), new NonSignificantVerbsRule(messages, (Language)this, userConfig), new UnnecessaryPhraseRule(messages, (Language)this, userConfig), new GermanParagraphRepeatBeginningRule(messages, (Language)this), new DuUpperLowerCaseRule(messages), new UnitConversionRule(messages), new MissingCommaRelativeClauseRule(messages), new MissingCommaRelativeClauseRule(messages, true), new RedundantModalOrAuxiliaryVerb(messages), new GermanReadabilityRule(messages, (Language)this, userConfig, true), new GermanReadabilityRule(messages, (Language)this, userConfig, false), new CompoundInfinitivRule(messages, (Language)this, userConfig), new StyleRepeatedVeryShortSentences(messages, (Language)this, userConfig), new StyleRepeatedSentenceBeginning(messages), new GermanRepeatedWordsRule(messages), new StyleTooOftenUsedVerbRule(messages, (Language)this, userConfig), new StyleTooOftenUsedNounRule(messages, (Language)this, userConfig), new StyleTooOftenUsedAdjectiveRule(messages, (Language)this, userConfig)});
    }

    public CompoundWordTokenizer getNonStrictCompoundSplitter() {
        GermanCompoundTokenizer tokenizer = GermanCompoundTokenizer.getNonStrictInstance();
        return word -> new ArrayList<String>(tokenizer.tokenize(word));
    }

    public GermanCompoundTokenizer getStrictCompoundTokenizer() {
        return GermanCompoundTokenizer.getStrictInstance();
    }

    public List<Rule> getRelevantLanguageModelRules(ResourceBundle messages, LanguageModel languageModel, UserConfig userConfig) throws IOException {
        return Arrays.asList(new Rule[]{new UpperCaseNgramRule(messages, languageModel, (Language)this), new GermanConfusionProbabilityRule(messages, languageModel, (Language)this), new ProhibitedCompoundRule(messages, languageModel, userConfig, (Language)this)});
    }

    public Tokenizer createDefaultWordTokenizer() {
        return new GermanWordTokenizer();
    }

    public String getOpeningDoubleQuote() {
        return "\u201e";
    }

    public String getClosingDoubleQuote() {
        return "\u201c";
    }

    public String getOpeningSingleQuote() {
        return "\u201a";
    }

    public String getClosingSingleQuote() {
        return "\u2018";
    }

    public boolean isAdvancedTypographyEnabled() {
        return true;
    }

    public String toAdvancedTypography(String input) {
        String output = super.toAdvancedTypography(input);
        output = TYPOGRAPHY_PATTERN.matcher(output).replaceAll("$1\u00a0$2");
        output = TYPOGRAPHY_PATTERN.matcher(output).replaceAll("$1\u00a0$2");
        return output;
    }

    public LanguageMaintainedState getMaintainedState() {
        return LanguageMaintainedState.ActivelyMaintained;
    }

    public Map<String, Integer> getPriorityMap() {
        return id2prio;
    }

    protected int getPriorityForId(String id) {
        Integer prio = id2prio.get(id);
        if (prio != null) {
            return prio;
        }
        if (id.startsWith("DE_PROHIBITED_COMPOUNDS_") || id.startsWith("DE_PROHIBITED_COMPOUNDS_PREMIUM_")) {
            return -4;
        }
        if (id.startsWith("DE_MULTITOKEN_SPELLING")) {
            return -2;
        }
        if (id.startsWith("CONFUSION_RULE_")) {
            return -1;
        }
        if (id.startsWith("AI_DE_HYDRA_LEO")) {
            if (id.startsWith("AI_DE_HYDRA_LEO_MISSING_COMMA")) {
                return -51;
            }
            if (id.startsWith("AI_DE_HYDRA_LEO_CP")) {
                return 2;
            }
            if (id.startsWith("AI_DE_HYDRA_LEO_DATAKK")) {
                return 1;
            }
            return -11;
        }
        if (id.startsWith("AI_DE_KOMMA")) {
            return -52;
        }
        if (id.startsWith("AI_DE_GGEC")) {
            switch (id) {
                case "AI_DE_GGEC_MISSING_PUNCTUATION_E_DASH_MAIL": {
                    return 0;
                }
                case "AI_DE_GGEC_REPLACEMENT_ADJECTIVE": 
                case "AI_DE_GGEC_REPLACEMENT_ADVERB": 
                case "AI_DE_GGEC_REPLACEMENT_NOUN": 
                case "AI_DE_GGEC_REPLACEMENT_ORTHOGRAPHY_LOWERCASE": 
                case "AI_DE_GGEC_REPLACEMENT_ORTHOGRAPHY_SPELL": 
                case "AI_DE_GGEC_REPLACEMENT_OTHER": 
                case "AI_DE_GGEC_REPLACEMENT_VERB": 
                case "AI_DE_GGEC_REPLACEMENT_VERB_FORM": 
                case "AI_DE_GGEC_UNNECESSARY_ORTHOGRAPHY_SPACE": 
                case "AI_DE_GGEC_UNNECESSARY_OTHER": 
                case "AI_DE_GGEC_UNNECESSARY_SPACE": {
                    return -1;
                }
            }
            if (id.startsWith("AI_DE_GGEC_MISSING_ORTHOGRAPHY_SPACE")) {
                return -2;
            }
            if (id.startsWith("AI_DE_GGEC_MISSING_PUNCTUATION_PERIOD")) {
                return -4;
            }
            if (id.startsWith("AI_DE_GGEC_UNNECESSARY_PUNCTUATION")) {
                return -2;
            }
            if (AI_DE_GGEC_MISSING_PUNCT.matcher(id).find()) {
                return -1;
            }
            return 1;
        }
        return super.getPriorityForId(id);
    }

    public boolean hasMinMatchesRules() {
        return true;
    }

    public List<RuleMatch> filterRuleMatches(List<RuleMatch> ruleMatches, AnnotatedText text, Set<String> enabledRules) {
        ArrayList<RuleMatch> resultMatches = new ArrayList<RuleMatch>();
        RuleMatch previousMatch = null;
        for (int i = 0; i < ruleMatches.size(); ++i) {
            RuleMatch currentMatch = ruleMatches.get(i);
            List suggestions = currentMatch.getSuggestedReplacements();
            if (suggestions.size() == 1 && currentMatch.getRule().getId().startsWith("AI_DE_GGEC")) {
                String suggestion = (String)suggestions.get(0);
                if (currentMatch.getRule().getId().equals("AI_DE_GGEC_MISSING_PUNCTUATION_PERIOD") && suggestion.endsWith(".") && currentMatch.getSentence().getText().replaceAll("\\s+$", "").endsWith(suggestion.substring(0, suggestion.length() - 1))) continue;
            }
            if (previousMatch != null && previousMatch.getRule().getId().startsWith("AI_DE_GGEC") && currentMatch.getRule().getId().startsWith("AI_DE_GGEC")) {
                if (previousMatch.getToPos() > currentMatch.getFromPos()) continue;
                if ((previousMatch.getToPos() == currentMatch.getFromPos() || previousMatch.getToPos() + 1 == currentMatch.getFromPos()) && previousMatch.getRule().getTags().contains(Tag.picky) == currentMatch.getRule().getTags().contains(Tag.picky)) {
                    RuleMatch mergedMatch;
                    if (previousMatch.getRule().getLocQualityIssueType() == currentMatch.getRule().getLocQualityIssueType()) {
                        previousMatch = mergedMatch = new RuleMatch(this.mergeMatches(previousMatch, currentMatch));
                        continue;
                    }
                    if (previousMatch.getRule().getLocQualityIssueType() != currentMatch.getRule().getLocQualityIssueType() && previousMatch.getRule().getLocQualityIssueType() != ITSIssueType.Style && currentMatch.getRule().getLocQualityIssueType() != ITSIssueType.Style) {
                        previousMatch = mergedMatch = new RuleMatch(this.mergeMatches(previousMatch, currentMatch));
                        continue;
                    }
                }
                resultMatches.add(previousMatch);
                previousMatch = currentMatch;
                continue;
            }
            if (previousMatch != null) {
                resultMatches.add(previousMatch);
            }
            previousMatch = currentMatch;
        }
        if (previousMatch != null) {
            resultMatches.add(previousMatch);
        }
        return resultMatches;
    }

    private RuleMatch mergeMatches(RuleMatch match1, RuleMatch match2) {
        String separator = "";
        if (match1.getToPos() + 1 == match2.getFromPos()) {
            separator = " ";
        }
        String newErrorStr = match1.getOriginalErrorStr() + separator + match2.getOriginalErrorStr();
        String newReplacement = (String)match1.getSuggestedReplacements().get(0) + separator + (String)match2.getSuggestedReplacements().get(0);
        RuleMatch mergedMatch = new RuleMatch(match1.getRule(), match1.getSentence(), match1.getFromPos(), match2.getToPos(), "Hier scheint es einen Fehler zu geben.", "Potenzieller Fehler");
        mergedMatch.setOriginalErrorStr(newErrorStr);
        mergedMatch.setSuggestedReplacement(newReplacement);
        String newId = "AI_DE_MERGED_MATCH";
        mergedMatch.setSpecificRuleId(newId);
        if (match1.getRule().getLocQualityIssueType() != match2.getRule().getLocQualityIssueType()) {
            mergedMatch.getRule().setLocQualityIssueType(ITSIssueType.Grammar);
        } else if (match1.getRule().getLocQualityIssueType() == ITSIssueType.Style && match2.getRule().getLocQualityIssueType() == ITSIssueType.Style) {
            mergedMatch.getRule().setLocQualityIssueType(ITSIssueType.Style);
        }
        return mergedMatch;
    }

    public List<String> prepareLineForSpeller(String line) {
        ArrayList<String> results = new ArrayList<String>();
        String[] parts = line.split("#");
        if (parts.length == 0) {
            return Collections.singletonList(line);
        }
        String[] formTag = parts[0].split("[/]");
        if (formTag.length == 0) {
            return Collections.singletonList("");
        }
        String form = formTag[0];
        results.add(form);
        String tag = "";
        if (formTag.length == 2) {
            tag = formTag[1];
        }
        if (tag.contains("E")) {
            results.add(form + "e");
        }
        if (tag.contains("S")) {
            results.add(form + "s");
        }
        if (tag.contains("N")) {
            results.add(form + "n");
        }
        return results;
    }

    public MultitokenSpeller getMultitokenSpeller() {
        return GermanMultitokenSpeller.INSTANCE;
    }

    @NotNull
    public static German getInstance() {
        throw new RuntimeException("You should not obtain the German language instance. Use getInstance method of derived language class instead. Or maybe subclass did not implement the getInstance method.");
    }

    static {
        id2prio.put("DE_PROHIBITED_PHRASE", 11);
        id2prio.put("WRONG_SPELLING_PREMIUM_INTERNAL", 10);
        id2prio.put("OLD_SPELLING_RULE", 10);
        id2prio.put("DE_COMPOUNDS", 10);
        id2prio.put("E_MAIL_SIGNATUR", 10);
        id2prio.put("TELEFON_NR", 10);
        id2prio.put("IRGEND_COMPOUND", 10);
        id2prio.put("DA_DURCH", 2);
        id2prio.put("BEI_GOOGLE", 2);
        id2prio.put("EINE_ORIGINAL_RECHNUNG_TEST", 2);
        id2prio.put("VON_SEITEN_RECOMMENDATION", 2);
        id2prio.put("AUFFORDERUNG_SIE", 2);
        id2prio.put("WEIS_ICH", 2);
        id2prio.put("VONSTATTEN_GEHEN", 2);
        id2prio.put("VERWECHSLUNG_MIR_DIR_MIR_DIE", 1);
        id2prio.put("ERNEUERBARE_ENERGIEN", 1);
        id2prio.put("DRIVE_IN", 1);
        id2prio.put("DIES_MAL", 1);
        id2prio.put("AN_STATT", 1);
        id2prio.put("VOR_BEI", 1);
        id2prio.put("SUB_VER_KLEIN", 1);
        id2prio.put("ALLES_GUTE", 1);
        id2prio.put("NEUN_NEUEN", 1);
        id2prio.put("VERWANDET_VERWANDTE", 1);
        id2prio.put("IN_DEUTSCHE_SPRACHE", 1);
        id2prio.put("SCHMIERE_STEHEN", 1);
        id2prio.put("UEBER_EIN_MANGEL", 1);
        id2prio.put("SEIT_LAENGEREN", 1);
        id2prio.put("WIR_GEFUEHL", 1);
        id2prio.put("VORHER_NACHHER_BILD", 1);
        id2prio.put("SEIT_KLEIN_AUF", 1);
        id2prio.put("SEIT_GEBURT_AN", 1);
        id2prio.put("WO_VON", 1);
        id2prio.put("ICH_BIN_STAND_JETZT_KOMMA", 1);
        id2prio.put("EIN_LOGGEN", 1);
        id2prio.put("ZU_GEN\u00dcGE", 1);
        id2prio.put("SEIT_BEKANNT_WERDEN", 1);
        id2prio.put("IMPFLICHT", 1);
        id2prio.put("NULL_KOMMA_NICHTS", 1);
        id2prio.put("ZWEI_AN_HALB", 1);
        id2prio.put("BLUETOOTH_LAUTSPRECHER", 1);
        id2prio.put("WIR_HABE", 1);
        id2prio.put("DAS_IST_GLAUBE_ICH_EGAL", 1);
        id2prio.put("ICH_KOENNT", 1);
        id2prio.put("HAT_DU", 1);
        id2prio.put("HAST_DICH", 1);
        id2prio.put("GRUNDE", 1);
        id2prio.put("EIN_FACH", 1);
        id2prio.put("WOGEN_SUBST", 1);
        id2prio.put("SO_WIES_IST", 1);
        id2prio.put("SICH_SICHT", 1);
        id2prio.put("MIT_VERANTWORTLICH", 1);
        id2prio.put("VOR_LACHEN", 1);
        id2prio.put("TOUREN_SUBST", 1);
        id2prio.put("AUF_DR\u00c4NGEN", 1);
        id2prio.put("AUF_ZACK", 1);
        id2prio.put("UNTER_DRUCK", 1);
        id2prio.put("ZUCCHINIS", 1);
        id2prio.put("PASSWORTE", 1);
        id2prio.put("ANGL_PA_ED_UNANGEMESSEN", 1);
        id2prio.put("ANFUEHRUNGSZEICHEN_DE_AT", 1);
        id2prio.put("ANFUEHRUNGSZEICHEN_CH_FR", 1);
        id2prio.put("EMAIL", 1);
        id2prio.put("IM_STICH_LASSEN", 1);
        id2prio.put("ZULANGE", 1);
        id2prio.put("ROCK_N_ROLL", 1);
        id2prio.put("JOE_BIDEN", 1);
        id2prio.put("ANS_OHNE_APOSTROPH", 1);
        id2prio.put("DIESEN_JAHRES", 1);
        id2prio.put("TAG_EIN_TAG_AUS", 1);
        id2prio.put("WERT_SEIN", 1);
        id2prio.put("EBEN_FALLS", 1);
        id2prio.put("AUSSER_ORDENTLICH", 1);
        id2prio.put("IN_UND_AUSWENDIG", 1);
        id2prio.put("HIER_MIT", 1);
        id2prio.put("HIER_FUER", 1);
        id2prio.put("MIT_REISSEN", 1);
        id2prio.put("JEDEN_FALLS", 1);
        id2prio.put("MOEGLICHER_WEISE_ETC", 1);
        id2prio.put("UST_ID", 1);
        id2prio.put("INS_FITNESS", 1);
        id2prio.put("MIT_UNTER", 1);
        id2prio.put("SEIT_VS_SEID", 1);
        id2prio.put("ZU_KOMMEN_LASSEN", 1);
        id2prio.put("ZU_SCHICKEN_LASSEN", 1);
        id2prio.put("IM_UM", 1);
        id2prio.put("EINEN_VERSUCH_WERT", 1);
        id2prio.put("DASS_DAS_PA2_DAS_PROIND", 1);
        id2prio.put("AUF_BITTEN", 1);
        id2prio.put("MEINET_WEGEN", 1);
        id2prio.put("FUER_INSBESONDERE", 1);
        id2prio.put("COVID_19", 1);
        id2prio.put("DA_VOR", 1);
        id2prio.put("DAS_WUENSCHE_ICH", 1);
        id2prio.put("KLEINSCHREIBUNG_MAL", 1);
        id2prio.put("VERINF_DAS_DASS_SUB", 1);
        id2prio.put("IM_ALTER", 1);
        id2prio.put("DAS_ALTER", 1);
        id2prio.put("VER_INF_PKT_VER_INF", 1);
        id2prio.put("DASS_MIT_VERB", 1);
        id2prio.put("AB_TEST", 1);
        id2prio.put("BZGL_ABK", 1);
        id2prio.put("DURCH_WACHSEN", 1);
        id2prio.put("RUNDUM_SORGLOS_PAKET", 1);
        id2prio.put("MIT_FREUNDLICHEN_GRUESSE", 1);
        id2prio.put("OK", 1);
        id2prio.put("EINE_ORIGINAL_RECHNUNG", 1);
        id2prio.put("WAEHRUNGSANGABEN_CHF", 1);
        id2prio.put("FALSCHES_ANFUEHRUNGSZEICHEN", -1);
        id2prio.put("VER_KOMMA_PRO_RIN", -1);
        id2prio.put("VER_INF_VER_INF", -1);
        id2prio.put("DE_COMPOUND_COHERENCY", -1);
        id2prio.put("GEFEATURED", -1);
        id2prio.put("NUMBER_SUB", -1);
        id2prio.put("MFG", -1);
        id2prio.put("VER123_VERAUXMOD", -1);
        id2prio.put("DE_AGREEMENT", -1);
        id2prio.put("DE_AGREEMENT2", -1);
        id2prio.put("KOMMA_NEBEN_UND_HAUPTSATZ", -1);
        id2prio.put("FALSCHES_RELATIVPRONOMEN", -1);
        id2prio.put("AKZENT_STATT_APOSTROPH", -1);
        id2prio.put("BEENDE_IST_SENTEND", -1);
        id2prio.put("VER_ADJ_ZU_SCHLAFEN", -1);
        id2prio.put("LT_RECOMMENDATION", -1);
        id2prio.put("MIO_PUNKT", -1);
        id2prio.put("AUSLASSUNGSPUNKTE_LEERZEICHEN", -1);
        id2prio.put("IM_ERSCHEINUNG_SPELLING_RULE", -1);
        id2prio.put("SPACE_BEFORE_OG", -1);
        id2prio.put("VERSEHENTLICHERWEISE", -1);
        id2prio.put("VERMOD_SKIP_VER_PKT", -1);
        id2prio.put("N_NETTER_TYP", -1);
        id2prio.put("EINZELBUCHSTABE_PREMIUM", -2);
        id2prio.put("ART_IND_ADJ_SUB", -2);
        id2prio.put("KATARI", -2);
        id2prio.put("SCHOENE_WETTER", -2);
        id2prio.put("MEIN_KLEIN_HAUS", -2);
        id2prio.put("UNPAIRED_BRACKETS", -2);
        id2prio.put("DE_UNPAIRED_QUOTES", -2);
        id2prio.put("ICH_GLAUBE_FUER_EUCH", -2);
        id2prio.put("OBJECT_AGREEMENT", -2);
        id2prio.put("ICH_INF_PREMIUM", -2);
        id2prio.put("MEHRERE_WOCHE_PREMIUM", -2);
        id2prio.put("DOPPELTER_NOMINATIV", -2);
        id2prio.put("KUDAMM", -2);
        id2prio.put("ALTERNATIVEN_FUER_ANGLIZISMEN", -2);
        id2prio.put("DOPPELUNG_VER_MOD_AUX", -2);
        id2prio.put("ANGLIZISMEN", -2);
        id2prio.put("ANGLIZISMUS_PA_MIT_ED", -2);
        id2prio.put("MEINSTE", -2);
        id2prio.put("ICH_LIEBS", -2);
        id2prio.put("WENNS_UND_ABERS", -2);
        id2prio.put("ABERS_SATZANFANG_SPELLING_RULE", -2);
        id2prio.put("VERNEB", -2);
        id2prio.put("ZAHL_IM_WORT_SPELLING_RULE", -2);
        id2prio.put("GERMAN_SPELLER_RULE", -3);
        id2prio.put("AUSTRIAN_GERMAN_SPELLER_RULE", -3);
        id2prio.put("SWISS_GERMAN_SPELLER_RULE", -3);
        id2prio.put("DE_VERBAGREEMENT", -4);
        id2prio.put("UPPERCASE_SENTENCE_START", -4);
        id2prio.put("PUNKT_ENDE_DIREKTE_REDE", -4);
        id2prio.put("LEERZEICHEN_NACH_VOR_ANFUEHRUNGSZEICHEN", -4);
        id2prio.put("ZEICHENSETZUNG_DIREKTE_REDE", -4);
        id2prio.put("GROSSSCHREIBUNG_WOERTLICHER_REDE", -4);
        id2prio.put("IM_IHM_SPELLING_RULE", -4);
        id2prio.put("IN_UNKNOWNKLEIN_VER", -4);
        id2prio.put("SEHR_GEEHRTER_NAME", -4);
        id2prio.put("DE_PHRASE_REPETITION", -4);
        id2prio.put("FRAGEZEICHEN_NACH_DIREKTER_REDE", -4);
        id2prio.put("PUNCTUATION_PARAGRAPH_END", -4);
        id2prio.put("F_ANSTATT_PH_2", -4);
        id2prio.put("DAS_WETTER_IST", -5);
        id2prio.put("VEREIZ_VERINF_PKT", -5);
        id2prio.put("WER_STARK_SCHWITZ", -5);
        id2prio.put("VERBEN_PRAEFIX_AUS", -5);
        id2prio.put("ANFUEHRUNG_VERSCHACHTELT", -5);
        id2prio.put("SATZBAU_AN_DEN_KOMMT", -5);
        id2prio.put("SUBJECT_VERB_AGREEMENT", -5);
        id2prio.put("SAGT_SAGT", -9);
        id2prio.put("VON_LEBENSLAEUFE_SPELLING_RULE", -12);
        id2prio.put("VER_WER_VER_3", -12);
        id2prio.put("PA_WAS", -12);
        id2prio.put("ICH_GEHE_DU_BLEIBST", -12);
        id2prio.put("PROPERNOMSIN_VERIMPSIN", -12);
        id2prio.put("DIESE_HABE_ER_BELEIDIGTE", -12);
        id2prio.put("VER123_VERAUXMOD_TEST1", -12);
        id2prio.put("ZUSAMMENGESETZTE_VERBEN", -12);
        id2prio.put("PRP_VER_PRGK", -13);
        id2prio.put("COMMA_IN_FRONT_RELATIVE_CLAUSE", -13);
        id2prio.put("SAGT_RUFT", -13);
        id2prio.put("KANNST_WERDEN", -13);
        id2prio.put("KOMMA_ZWISCHEN_HAUPT_UND_NEBENSATZ_2", -14);
        id2prio.put("MAN_SIEHT_SEHR_SCHOEN", -14);
        id2prio.put("BEI_VERB", -14);
        id2prio.put("MODALVERB_FLEKT_VERB", -14);
        id2prio.put("DATIV_NACH_PRP", -14);
        id2prio.put("DAT_ODER_AKK_NACH_PRP", -14);
        id2prio.put("SENT_START_SIN_PLU", -14);
        id2prio.put("SENT_START_PLU_SIN", -14);
        id2prio.put("VER_INFNOMEN", -14);
        id2prio.put("GERMAN_WORD_REPEAT_RULE", -15);
        id2prio.put("TOO_LONG_PARAGRAPH", -15);
        id2prio.put("ALL_UPPERCASE", -15);
        id2prio.put("NUR_LEDIGLICH", -16);
        id2prio.put("STYLE_KEINE_AHNUNG", -16);
        id2prio.put("COMMA_BEHIND_RELATIVE_CLAUSE", -52);
        id2prio.put("DOPPELUNG_MODALVERB", -52);
        id2prio.put("VER_DOPPELUNG", -52);
        id2prio.put("DEF_ARTIKEL_INDEF_ADJ", -52);
        id2prio.put("PRP_ADJ_AGREEMENT", -52);
        id2prio.put("SIE_WOLLTEN_SIND", -52);
        id2prio.put("ART_ADJ_SOL", -52);
        id2prio.put("WURDEN_WORDEN_1", -52);
        id2prio.put("WAR_WAHR", -52);
        id2prio.put("KOMMA_ZWISCHEN_HAUPT_UND_NEBENSATZ", -53);
        id2prio.put("VERB_IST", -53);
        id2prio.put("WAR_WERDEN", -53);
        id2prio.put("INF_VER_MOD_SPELLING_RULE", -53);
        id2prio.put("DOPPELTES_VERB", -53);
        id2prio.put("VERB_FEM_SUBST", -54);
        id2prio.put("SUBJUNKTION_KOMMA_2", -54);
        id2prio.put("DOPPELUNG_GLEICHES_VERB", -55);
        id2prio.put("FEHLENDES_NOMEN", -60);
        id2prio.put("REPETITIONS_STYLE", -60);
        id2prio.put("GERMAN_WORD_REPEAT_BEGINNING_RULE", -61);
        id2prio.put("TYPOGRAPHY", -14);
        id2prio.put("COLLOQUIALISMS", -15);
        id2prio.put("STYLE", -15);
        id2prio.put("REDUNDANCY", -15);
        id2prio.put("GENDER_NEUTRALITY", -15);
    }
}

